import { get, put, post, File, deleteReq } from '@/utils/http'
const baseURL = import.meta.env.VITE_LOCAL== 'true' ? '/api' : import.meta.env.VITE_HTTP_BASE_URL
const api = {
    //列表查询
    getSelfServiceList(data={}) {
        return post(`${baseURL}/app/api/app/agency/auth/query`, data)
    },
    //查询关联项目
    getContracNumberList(data={}){
        return post(`${baseURL}/app/api/app/bind/contract/query/all`, data)
    },
    //查询所有区域
    getAreaList(data={}){
        return post(`${baseURL}/app/api/app/agency/area/query`, data)
    },
    //查询代理店信息
    getAgencyList(data={}){
        return post(`${baseURL}/app/api/app/agency/query`, data)
    },
    //确认授权代理店单据
    confrimAgent(data={}){
        return post(`${baseURL}/app/api/app/agency/auth/confirm`, data)
    }
};

export default api;
