import { post } from '@/utils/http'

const baseURL = import.meta.env.DEV ? '/api' : import.meta.env.VITE_HTTP_BASE_URL

const api = {
  // 首页查询
  contractQueryAll(data = {}) {
    return post(`${baseURL}/app/api/app/bind/contract/query/all`, data)
  },
  // 解绑
  contractDelete(data = {}) {
    return post(`${baseURL}/app/api/app/bind/contract/delete`, data)
  },
  // 查询指定项目信息
  contractQuery(data = {}) {
    return post(`${baseURL}/app/api/app/specify/contract/query`, data)
  },
  // 校验手机号并发送 验证码
  phoneValid(data = {}) {
    return post(`${baseURL}/app/api/app/specify/contract/phone/valid`, data)
  },
  //  校验验证码
  codeValid(data = {}) {
    return post(`${baseURL}/app/api/app/specify/contract/code/valid`, data)
  },
  // 绑定指定项目
  contractBind(data = {}) {
    return post(`${baseURL}/app/api/app/specify/contract/bind`, data)
  },


};

export default api;
