//  转成金钱字符串
export function currency(num, dotNum = 2) {
  if (num===null || num===undefined || isNaN(+num)) return num;
  return (+num).toLocaleString("en-US", { style: "decimal", minimumFractionDigits: dotNum, maximumFractionDigits: dotNum });
}

// 金钱去除逗号
export function currencyToString(value) {
  return value.replace(/[,]*/g, '');
}

// YYYY-MM-DD HH:MM:SS' => YYYY-MM-DD
export function dateFormat(timestamp) {
  if (!timestamp) return '';
  var newDate = /\d{4}-\d{1,2}-\d{1,2}/g.exec(timestamp);
  return newDate[0];
}

// 将时间字符串转换为 'YYYY-MM-DD HH:MM:SS'
export function dateFormatUP(dateString) {
  let date = typeof (dateString) == 'string' ? iosDateFormat(dateString) : dateString;
  if (!date?.toLocaleDateString) return dateString;
  return date.toLocaleString("sv-SE");
}

// 小数转成百分数
export function toPercent(val, needSign = true, dotNum = 2) {
  if (!val || isNaN(+val)) return '0.00%';
  let res = (+val).toLocaleString("zh-CN", { style: "percent", minimumFractionDigits: dotNum });
  return needSign ? res : res.replace('%', '');
}

// ios 日期转换 日期从 xxxx-xx-xx 变为 xxxx/xx/xx  ios 不支持 new Date('xxxx-xxxx-xx')
export function iosDateFormat(timeString) {
  if (!timeString) return timeString;

  return new Date(timeString.replace(/-/g, '/'))
}

// url query解析
export const getQuery = (url) => {
  // str为？之后的参数部分字符串
  const str = url.substr(url.indexOf('?') + 1)
  // arr每个元素都是完整的参数键值
  const arr = str.split('&')
  // result为存储参数键值的集合
  const result = {}
  for (let i = 0; i < arr.length; i++) {
    // item的两个元素分别为参数名和参数值
    const item = arr[i].split('=')
    result[item[0]] = item[1]
  }
  return result
} 