import { get } from '@/utils/http'
import Base64_Encode from 'crypto-js/enc-base64';
import HmacSHA256 from 'crypto-js/hmac-sha256';
import SHA256_HEX from 'crypto-js/sha256';

const AlipayBaseUrl = import.meta.env.VITE_Alipay
const WechatBaseUrl = import.meta.env.VITE_Wechat
const UnionpayBaseUrl = import.meta.env.VITE_Unionpay

// 下单
const pay = (payType = 'alipay') => {
  let getBaseUrl = {
    alipay: AlipayBaseUrl,
    wechat: WechatBaseUrl,
    unionpay: UnionpayBaseUrl
  }

  const appId = '10037ca75e6125aa015e9e12a89b001b';
  const AppKey = 'f7a74b6c02ae4e1e94aaba311c04acf2';
  const timestamp = getTimestamp();
  const nonce = randomString();
  const content = {
    "requestTimestamp": getTimestamp(true),  // 报文请求时间
    "mid": "898201612345678",  // 商户号
    "tid": "88880001", // 终端号
    "instMid": "H5DEFAULT", // 业务类型YUEDANDEFAULT
    "totalAmount": 0.1, // 支付总金额
    "notifyUrl": "https://qrtest2.chinaums.com/netpayportal/test/notifyUrl.do", // 支付结果通知地址
    "returnUrl": "https://qrtest2.chinaums.com/netpayportal/test/returnUrl.do", // 支付结果回跳商户页面
    "merOrderId": randomString(true)  // 商户订单号 商户自行生成  6..32
  }
  const signature = Base64_Encode(HmacSHA256(appId + timestamp + nonce + SHA256_HEX(JSON.stringify(content)), AppKey))

  let params = { appId, timestamp, nonce, signature, content }

  return get(getBaseUrl[payType] + urlencode(addQueryString(params)));
}


function randomString(OnlyNumber = false, e) {
  e = e || 32;
  var t = "abcdefhijkmnprstwxyz0123456789",
    t2 = "1234567890",
    a = t.length,
    n = "";
  if (OnlyNumber) t = t2;
  for (let i = 0; i < e; i++) n += t.charAt(Math.floor(Math.random() * a));
  return n
}

function urlencode(str) {
  str = (str + '').toString();
  return encodeURIComponent(str).replace(/!/g, '%21').replace(/'/g, '%27').replace(/\(/g, '%28').
    replace(/\)/g, '%29').replace(/\*/g, '%2A').replace(/%20/g, '+');
}

function addQueryString(params) {
  var str = '';
  for (var Key in params) {
    str += Key + '=' + params[Key] + '&';
  }
  return '?' + str;
  //return '?' + str.substr(0, str.length -1); 严谨一些
}

function getTimestamp(isRequestTimestamp = false) {
  let now = new Date(),
    y = now.getFullYear(),
    M = now.getMonth() + 1,
    d = now.getDate(),
    h = now.getHours(),
    m = now.getMinutes(),
    s = now.getSeconds();

  let addZero = (n) => (n < 10 ? "0" + n : n);

  if (isRequestTimestamp) {
    return y + '-' + addZero(M) + '-' + addZero(d) + '-' + addZero(h) + ':' + addZero(m) + ':' + addZero(s);
  }

  return '' + y + addZero(M) + addZero(d) + addZero(h) + addZero(m) + addZero(s);
}

export { pay }
