import { getQuery } from "./textFormat"

// 桥登录
export function bridgeLogin() {
    return new Promise((resolve) => {
        // 调用成功返回
        window.onSuccess = function (message) {
            console.log('BaseBridge：', message)
            let object = handleSpecialCharacters(message)
            const data = {
                token: object.token,
                userId: object.userId,
                organizationId: object.tenantId,
                pushExtra: object.pushExtra
            }
            window.localStorage.setItem('userId', object.userId)
            window.localStorage.setItem('phone', object.loginAccount)
            resolve(data)
        }

        // 调用失败返回
        window.onError = function (message) {
            alert(message)
        }
        // 调用方法
        let args = {
            className: 'BaseBridge',
            function: 'getBaseInfo',
            successCallBack: 'onSuccess',
            failCallBack: 'onError',
        }
        HandBridge.postMessage(JSON.stringify(args))
    })
}

export default async function login(token = '') {
    let result = {}
    if (token === '') {
        result = await bridgeLogin() // 本地子应用
        console.log('登录返回信息', JSON.stringify(result))
    } else {
        result.token = token
    }

    window.localStorage.access_token = result.token

    return NoticeAndReplaceRouter(result.pushExtra)
}


export function handleSpecialCharacters(jsonStr) {
    let obj = {};
    if (jsonStr && Object.prototype.toString.call(jsonStr) == "[object String]" && jsonStr != 'null') {
        jsonStr = jsonStr.replace(/\r/g, "\\r");
        jsonStr = jsonStr.replace(/\n/g, "\\n");
        jsonStr = jsonStr.replace(/\t/g, "\\t");
        jsonStr = jsonStr.replace(/\\/g, "\\\\");
        jsonStr = jsonStr.replace(/\'/g, "&#39;");
        jsonStr = jsonStr.replace(/ /g, "&nbsp;");
        jsonStr = jsonStr.replace(/</g, "$lt;");
        jsonStr = jsonStr.replace(/>/g, "$gt;");
        try {
            obj = JSON.parse(jsonStr)
        } catch (e) {
            let jsonArr = jsonStr.split('')
            let start = jsonStr.indexOf('"project":') + '"project":'.length
            let end = jsonStr.indexOf('}"', start)
            jsonArr.splice(start, 1)
            jsonArr.splice(end, 1)
            jsonStr = jsonArr.join('')
            obj = JSON.parse(jsonStr)
        }
    }
    return obj;
}


// 通知消息跳转页面
function NoticeAndReplaceRouter(message) {
    if (!message || !message.path) return {};
    const path = message.path.match(/#(.*)\?/)[1]
    const query = getQuery(message.path)
    query.name = message.workflowTaskName
    console.log(path, query, '跳转参数与地址');

    return { path, query }
}


