// 引入axios
import axios from 'axios'
import qs from 'qs'
import {
  Dialog,
  Toast
} from "vant";

let promiseArr = {}
let cancel = {}
let url=''
const CancelToken = axios.CancelToken
// 请求拦截器
axios.interceptors.request.use((config) => {
  Toast.loading({
    duration: 0,
    forbidClick: true,
    message: '加载中...',
  });
  url=config.url;
  // 发起请求时，取消掉当前正在进行的相同请求
  config.cancelToken = new CancelToken((c) => {
    cancel = c
  })
  // if (promiseArr[config.url]) {
  //   promiseArr[config.url]('操作取消')
  //   promiseArr[config.url] = cancel
  // } else {
  //   promiseArr[config.url] = cancel
  // }
  return config
}, (error) => {
  Toast.clear();
  return Promise.reject(error)
})
// 响应拦截器即异常处理
axios.interceptors.response.use((response) => {
  Toast.clear();
  if (response.data.failed) {
    const err = {}
    err.message = response.data.message
    Dialog.alert({
      title: "提示",
      message: err.response?.data?.message || err.message
    });
    return Promise.resolve(err)
  }
  return response.data

}, (err) => {
  Toast.clear();
  if (err && err.response) {
    switch (err.response.status) {
      case 400:
        err.message = '错误请求'
        break
      case 401:
        err.message = '登录已失效，请重新登录'
        break
      case 403:
        err.message = '拒绝访问'
        break
      case 404:
        err.message = '请求错误,未找到该资源'
        break
      case 405:
        err.message = '不支持的请求类型'
        break
      case 408:
        err.message = '请求超时'
        break
      case 500:
        err.message = '服务器端出错'
        break
      case 501:
        err.message = '网络未实现'
        break
      case 502:
        err.message = '网络错误'
        break
      case 503:
        err.message = '服务不可用'
        break
      case 504:
        err.message = '网络超时'
        break
      case 505:
        err.message = 'http版本不支持该请求'
        break
      default:
        err.message = `连接错误${err.response.status}`
    }
  } else {
    // err.message = '连接到服务器失败'
  }

  if (err.response && err.response.status === 401) {
    Dialog.alert({
      title: "提示",
      message: '登录失效，重新登录'
    }).then(() => {
      let argument = {
        className: 'BaseBridge',
        function: 'closeWebView',
        successCallBack: 'onSuccess',
        failCallBack: 'onError',
      }
      HandBridge.postMessage(JSON.stringify(argument))
    });
  } else {
    if(!url.includes('bp-masters/wt-ocr') && !url.includes('invoice-input-hds/in-ocr')){
      Dialog.alert({
        title: "提示",
        message: err.response?.data?.message || err.message
      });
    }

  }
  return Promise.resolve(err.response?.data)
})
axios.defaults.baseURL = ''
axios.defaults.timeout = 100000
axios.defaults.paramsSerializer = (params) => {
  return qs.stringify(params, { arrayFormat: 'repeat' })
}
// get请求
export function get(url, param = {}) {
  let headers = {}
  if (window.localStorage.access_token) {
    headers = {
      'Content-Type': 'application/json',
      'Authorization': 'bearer ' + window.localStorage.access_token,
    }
  } else {
    headers = {
      'Content-Type': 'application/json',
    }
  }
  return new Promise((resolve, reject) => {
    axios({
      method: 'get',
      url,
      headers: headers,
      params: param,
    }).then((res) => {
      resolve(res)
    }).catch((err) => {
      reject(err)
    })
  })
}
// post请求
export function post(url, param = {}) {
  // param.user_id = window.localStorage.user_id
  // param.access_token = window.localStorage.access_token
  let headers = {}
  if (window.localStorage.access_token) {
    headers = {
      'Content-Type': 'application/json',
      'Authorization': 'bearer ' + window.localStorage.access_token,
    }
  } else {
    headers = {
      'Content-Type': 'application/json',
    }
  }
  return new Promise((resolve, reject) => {
    axios({
      method: 'post',
      headers: headers,
      url,
      data: {...param, _token: window.localStorage.getItem('_token')},
    }).then((res) => {
      resolve(res)
    }).catch((err) => {
      reject(err)
    })
  })
}
// filePost
export function File(url, param = {}) {
  // param.user_id = window.localStorage.user_id
  // param.access_token = window.localStorage.access_token
  let headers = {}
  if (window.localStorage.access_token) {
    headers = {
      'Content-Type': 'multipart/form-data; boundary=----WebKitFormBoundaryow7UgxtxnPN2CSLo',
      'Authorization': 'bearer ' + window.localStorage.access_token,
    }
  } else {
    headers = {
      'Content-Type': 'application/json',
    }
  }
  return new Promise((resolve, reject) => {
    axios({
      method: 'post',
      headers: headers,
      url,
      data: param,
    }).then((res) => {
      resolve(res)
    }).catch((err) => {
      reject(err)
    })
  })
}
// put请求
export function put(url, param = {}) {
  // param.user_id = window.localStorage.user_id
  // param.access_token = window.localStorage.access_token
  let headers = {}
  if (window.localStorage.access_token) {
    headers = {
      'Content-Type': 'application/json',
      'Authorization': 'bearer ' + window.localStorage.access_token,
    }
  } else {
    headers = {
      'Content-Type': 'application/json',
    }
  }
  return new Promise((resolve, reject) => {
    axios({
      method: 'put',
      headers: headers,
      url,
      data: param,
    }).then((res) => {
      resolve(res)
    }).catch((err) => {
      reject(err)
    })
  })
}

// delete 请求
export function deleteReq(url, param = {}) {
  // param.user_id = window.localStorage.user_id
  // param.access_token = window.localStorage.access_token
  let headers = {}
  if (window.localStorage.access_token) {
    headers = {
      'Content-Type': 'application/json',
      'Authorization': 'bearer ' + window.localStorage.access_token,
    }
  } else {
    headers = {
      'Content-Type': 'application/json',
    }
  }
  return new Promise((resolve, reject) => {
    axios({
      method: 'delete',
      headers: headers,
      url,
      data: param,
    }).then((res) => {
      resolve(res)
    }).catch((err) => {
      reject(err)
    })
  })
}
