import { Files, Device, Camera } from '@hips/plugin-vue-jssdk'
import { Toast } from "vant";
const { download, previewOffice, upload } = Files
const { deviceInfo, copyClipboard } = Device;
const { captureImage, chooseImage } = Camera;
import { get, post, put, File } from '@/utils/http'
let baseUrl = import.meta.env.VITE_HTTP_BASE_URL


// 字典转换成对应格式
export function handleDict(arr) {
  return arr.map(item => {
    let val = {
      text: item.description || item.meaning,
      value: item.value || item.bpCategory,
      parentValue: item.parentValue
    }

    if ('bpTypes' in item) {
      val.bpTypes = item.bpTypes
    }
    return val

  })
}

// 获取字典中对应的 文本信息
export function getDictText(value, dict) {
  if (!value || !dict.length) return ''
  let valueObj = dict.find(item => item.value === value)
  if (!valueObj) return ''
  return valueObj.meaning ?? valueObj.text
}

// 检测某个 value 是否在 字典中
export function inDict(value, dict) {
  if (!value || !dict.length) return false
  let valueObj = dict.find(item => item.value === value)
  return !!valueObj
}

export function isObject(obj) {
  return Object.prototype.toString.call(obj) === '[object Object]'
}

// hlps下载文件
export async function HIPSDownLoad(url) {
  console.log(url);

  if (await isAndroid()) {
    console.log('android');
    await previewOffice(url)
  } else {
    console.log('ios');

    if (/.pdf/.test(url)) {
      await loadWebUrl(url)
    } else {
      await Copy(url, '已将文件地址复制至剪切板，请至浏览器下载')
    }
  }
}

// ios 下加载 url
async function loadWebUrl(url) {
  function successCallBack(res) {
    console.log('ios suc', res)
  }
  function failCallBack(res) {
    console.log('ios err', res)
  }

  var args = {
    className: "WebViewBridge",
    function: "loadWebView",
    params: {
      url,
      encode: 1
    },
    successCallBack,
    failCallBack
  }

  await HandBridge.postMessage(JSON.stringify(args));
}

export async function isAndroid() {
  let { data, success } = await deviceInfo()
  if (success && data.platform === 'Android') return true
  return false
}

export async function Copy(value, message) {
  let { success } = await copyClipboard(value)
  if (success) Toast.success(message)
}

// 使用相机拍摄 参数： 允许编辑， 图片形状 （1：矩形，2：正方形， 0，圆）
export async function toCamera(allowEdit = true, targetSharp = 1) {
  let res = await captureImage({
    allowEdit: false,
  })
  return res
}

//  使用 相册获取图片
export async function toAlbum(maxSize = 1) {
  let res = await chooseImage()
  return res
}

// 得到ocr的结果
export function getOcrResult(file, params = {}) {
  const formData = new FormData()

  formData.append('file', file)

  for (const key in params) formData.append(key, params[key])

  return File(`${baseUrl}/v1/0/bp-masters/wt-ocr`, formData)
}

// 得到 Ocr选项列表
export async function getOcrList() {
  return handleDict(await getDict('HLCM.OCR_TYPE'))
}

async function getDict(code) {
  return await get(`${baseUrl}/hpfm/v1/0/lovs/data`, { lovCode: code })
}

export async function HlpsUpload(source, target, headers, successCb) {
  await upload({
    source,
    target,
    headers: {
      Authorization: 'bearer ' + window.localStorage.access_token,
      ...headers
    },
    onProgress: (progress) => { },
    onFinish: successCb,
    onFail: (err) => { Toast.fail('上传失败，请重试') },
  })
}

// 判断还有可返回的路由吗？ 无则退出
export const goBack = (isExit = false) => {
  if (Object.prototype.toString.call(isExit) === "[object PointerEvent]") isExit = false
  if (window.history.state.position > 0 && !isExit) {
    window.history.back();
    return
  }

  // 海马汇退出子应用方法
  let args = {
    className: "BaseBridge",
    function: "closeWebView",
    successCallBack: "onSuccess",
    failCallBack: "onError",
  };
  HandBridge.postMessage(JSON.stringify(args));
};