import { get, put, post, File, deleteReq } from '@/utils/http'

const baseURL = import.meta.env.VITE_LOCAL == 'true' ? '/api' : import.meta.env.VITE_HTTP_BASE_URL

const api = {
    //列表查询
    getRepayPlantList(data={}) {
        return post(`${baseURL}/app/api/app/repayment/details`, data)
    },
    //还款计划明细
    getRepaymentDetails(data={}){
        return post(`${baseURL}/app/api/app/project/repayment/details`, data)
    },
    // 发票下载
    downloadInvoice(data={}){
        return post(`${baseURL}/app/api/app/repayment/payment/invoice/get`, data)
    }


};

export default api;

