import { get, put, post, File, deleteReq } from '@/utils/http'

const baseURL = import.meta.env.DEV ? '/api' : import.meta.env.VITE_HTTP_BASE_URL

const api = {
    // 首页查询
    getProjectList(data = {}) {
        return post(`${baseURL}/app/api/app/project/first/page`, data)
    },
    // 明细查询
    getProjectDetail(data ={}){
        return post(`${baseURL}/app/api/app/project/query`, data)
    },
    //还款计划明细
    getRepaymentDetails(data={}){
        return post(`${baseURL}/app/api/app/project/repayment/details`, data)
    }
};

export default api;

