package com.hand.hls.hlcm.util;

import com.hand.hls.hlcm.contact.service.IBusinessContactService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author stone shen
 * @version 1.0
 * @date 2020/4/21 9:33
 * @description
 */
public class DelHtmlScript {
    @Autowired
    private IBusinessContactService service;
    /**
     * 定义script的正则表达式
     */
    public static final String regEx_script="<script[^>]*?>[\\s\\S]*?<\\/script>";
    /**
     *     定义style的正则表达式
     */
    public static final String regEx_style="<style[^>]*?>[\\s\\S]*?<\\/style>";
    /**
     *     定义HTML标签的正则表达式
     */
    public  static final String regEx_html="<[^>]+>";

    public static String delHtmlTag(String htmlStr){

        Pattern p_script=Pattern.compile(regEx_script,Pattern.CASE_INSENSITIVE);
        Matcher m_script=p_script.matcher(htmlStr);
        //过滤script标签
        htmlStr=m_script.replaceAll("");
        Pattern p_style=Pattern.compile(regEx_style,Pattern.CASE_INSENSITIVE);
        Matcher m_style=p_style.matcher(htmlStr);
        //过滤style标签
        htmlStr=m_style.replaceAll("");

        Pattern p_html=Pattern.compile(regEx_html,Pattern.CASE_INSENSITIVE);
        Matcher m_html=p_html.matcher(htmlStr);
        //过滤html标签
        htmlStr=m_html.replaceAll("");
        //返回文本字符串
        return htmlStr.trim();
    }

}
