package leaf.presentation.component.std.config;

import leaf.application.LeafApplication;
import com.alibaba.fastjson.JSONArray;
import uncertain.composite.CompositeMap;

public class HlsAnalyseCountChartConfig extends ComponentConfig {
    public static final String VERSION = "$Revision: 1.1 $";
    public static final String TAG_NAME = "hlsAnalyseCountChart";

    public static final String PROPERTY_FIELD_STATUS = "status";
    public static final String PROPERTY_FIELD_COLOR = "color";
    public static final String PROPERTY_FIELD_CLICK_FUNC = "clickfuc";
    public static final String PROPERTY_FIELD_HAVE_TITLE = "havetitle";
    public static final String PROPERTY_FIELD_ITEMS = "items";
    public static final String PROPERTY_FIELD_TITLE = "title";
    public static final String PROPERTY_FIELD_RIGHT_TITLE = "righttitle";

    public static HlsAnalyseCountChartConfig getInstance() {
        HlsAnalyseCountChartConfig model = new HlsAnalyseCountChartConfig();
        model.initialize(HlsAnalyseCountChartConfig.createContext(null, TAG_NAME));
        return model;
    }

    public static HlsAnalyseCountChartConfig getInstance(CompositeMap context) {
        HlsAnalyseCountChartConfig model = new HlsAnalyseCountChartConfig();
        CompositeMap map = HlsAnalyseCountChartConfig.createContext(context, TAG_NAME);
        map.setNameSpaceURI(LeafApplication.LEAF_FRAMEWORK_NAMESPACE);
        model.initialize(map);
        return model;
    }

    public String getRightTitle() {
        return getString(PROPERTY_FIELD_RIGHT_TITLE);
    }

    public void setRightTitle(String rightTitle) {
        putString(PROPERTY_FIELD_RIGHT_TITLE, rightTitle);
    }

    public String getTitle() {
        return getString(PROPERTY_FIELD_TITLE);
    }

    public void setTitle(String title) {
        putString(PROPERTY_FIELD_TITLE, title);
    }

    public String getStatus() {
        return getString(PROPERTY_FIELD_STATUS);
    }

    public void setStatus(String status) {
        putString(PROPERTY_FIELD_STATUS, status);
    }

    public String getColor() {
        return getString(PROPERTY_FIELD_COLOR);
    }

    public void setColor(String color) {
        putString(PROPERTY_FIELD_COLOR, color);
    }

    public String getClickFunc() {
        return getString(PROPERTY_FIELD_CLICK_FUNC);
    }

    public void setClickFunc(String clickFunc) {
        putString(PROPERTY_FIELD_CLICK_FUNC, clickFunc);
    }

    public String getHaveTitle() {
        return getString(PROPERTY_FIELD_HAVE_TITLE);
    }

    public void setHaveTitle(String haveTitle) {
        putString(PROPERTY_FIELD_HAVE_TITLE, haveTitle);
    }

    public JSONArray getItem() {
        CompositeMap context = getObjectContext();
        CompositeMap items = context.getChild(PROPERTY_FIELD_ITEMS);
        if (items == null) {
            items = new CompositeMap(PROPERTY_FIELD_ITEMS);
            context.addChild(items);
        }
        return (JSONArray) JSONArray.toJSON(items.getChilds());
    }

    public CompositeMap getItems() {
        CompositeMap context = getObjectContext();
        CompositeMap items = context.getChild(PROPERTY_FIELD_ITEMS);
        if (items == null) {
            items = new CompositeMap(PROPERTY_FIELD_ITEMS);
            context.addChild(items);
        }
        return items;
    }

    public void addItem(HlsItemConfig item) {
        CompositeMap items = getItems();
        items.addChild(item.getObjectContext());
    }


}
