package com.hand.hls.hlcm.acr.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hls.hlcm.acr.dto.AcrInvoiceHd;
import com.hand.hls.hlcm.acr.service.IAcrInvoiceHdService;
import com.hand.hls.hlcm.util.ResMessageException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @Author Robert8900
 * @Date: 2018/8/24 17:17
 * @Description:发票 controller
 * @Purpose:
 **/
@Controller
public class AcrInvoiceHdController extends BaseController {
    @Autowired
    private IAcrInvoiceHdService iAcrInvoiceHdService;

    //金税接口发票开票接口入口
    @RequestMapping(value = "/acr/invoice/info/submit")
    @ResponseBody
    public ResponseData acrInvoiceInfoSubmit(@RequestBody List<AcrInvoiceHd> acrInvoiceHds, HttpServletRequest request) throws ResMessageException {
        ResponseData responseData = new ResponseData();
        IRequest requestContext = createRequestContext(request);
        ResponseData data = null;

        data = iAcrInvoiceHdService.acrInvoiceInfoSubmit(requestContext,acrInvoiceHds);

        if(!data.isSuccess()){
            responseData.setSuccess(false);
            responseData.setMessage(data.getMessage());
        }else{
            responseData.setSuccess(true);
        }
        return  responseData;
    }

    //金税接口发票下载接口入口
    @RequestMapping(value = "/acr/invoice/info/download")
    @ResponseBody
    public ResponseData acrInvoiceInfoDownload(@RequestBody List<AcrInvoiceHd> acrInvoiceHds, HttpServletRequest request) throws ResMessageException {
        ResponseData responseData = new ResponseData();
        IRequest requestContext = createRequestContext(request);
        ResponseData data = iAcrInvoiceHdService.acrInvoiceInfoDownload(requestContext,acrInvoiceHds);
        if(!data.isSuccess()){
            responseData.setSuccess(false);
            responseData.setMessage(data.getMessage());
        }else{
            responseData.setSuccess(true);
        }
        return  responseData;
    }
}
