function RenderWithDrawChart(config) {
    this.days = config.days || 30;//时间跨度
    this.dateField = config.dateField;//日期字段
    this.totalDom = config.totalDom;//总额节点
    this.canvasDom = config.canvasDom;//渲染画布的节点
    this.amountField = config.amountField;//金额字段
    this.queryUrl = config.queryUrl;//查询Url
    this.results = [];
}

RenderWithDrawChart.prototype = {
    init: function () {
        jQuery.ajax({
            url: this.queryUrl,
            type: 'get',
            async: false,
            success: function (datas) {
                if (datas.success) {
                    if (!(datas.result.record instanceof Array)) {
                        this.results = new Array(datas.result.record);
                    } else {
                        this.results = datas.result.record;
                    }
                    jQuery(this.totalDom).html(this.getAllCount());
                    this.results = this.resultFilter();
                    this.htmlCanvasDom();
                }
            }.bind(this)
        })
    },
    resultFilter: function () {
        var opt = this;
        return this.results.filter(function (val) {
            return opt.checkDuring(opt.getDate(val[this.dateField]));
        })
    },
    //根据字符串获取date
    getDate: function (dateString) {
        return new Date(Date.parse(dateString));
    },
    //检测是否在时间范围内
    checkDuring: function (date) {
        var now = new Date();
        return date <= now && date >= new Date(now.getFullYear(), now.getMonth(), now.getDate());
    },
    //计算总金额
    getAllCount: function () {
        var opt = this;
        return this.results.reduce(function (prev, curr) {
            return plus(prev, curr[opt.amountField]);
        })
    },
    htmlCanvasDom: function () {
        var nowTime = new Date().getTime();
        var oneDayTime = 24 * 60 * 60 * 1000;//一天
        var arr = [];
        for (var i = this.days; i > 0; i--) {
            var oneDayCount = 0;//当天金额总计
            this.results.forEach(function (val) {

                if (Date.parse(val[this.dateField]) >= nowTime - (i * oneDayTime)
                    && Date.parse(val[this.dateField]) < nowTime - ((i - 1) * oneDayTime)) {
                    oneDayCount = plus(oneDayCount, val[this.amountField]);
                }
            });
            arr.push(oneDayCount);
        }
        jQuery(this.canvasDom).html(arr.join());
    }
};