package leaf.presentation.component.std;

import leaf.presentation.BuildSession;
import leaf.presentation.ViewContext;
import leaf.presentation.component.std.config.HlsAnalyseCountChartConfig;
import uncertain.composite.CompositeMap;
import uncertain.ocm.IObjectRegistry;

import java.io.IOException;
import java.util.Map;

public class HlsAnalyseCountChart extends HlsComponentChart {

    public HlsAnalyseCountChart(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
//        addJavaScript(session, context, "hlscomponent/hls-component-chart.js");
    }

    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
        Map map = context.getMap();
        CompositeMap view = context.getView();
        HlsAnalyseCountChartConfig mbc = HlsAnalyseCountChartConfig.getInstance(view);
        map.put(HlsAnalyseCountChartConfig.PROPERTITY_BINDTARGET, mbc.getBindTarget());
        map.put(HlsAnalyseCountChartConfig.PROPERTY_FIELD_STATUS, mbc.getStatus());
        map.put(HlsAnalyseCountChartConfig.PROPERTY_FIELD_CLICK_FUNC, mbc.getClickFunc());
        map.put(HlsAnalyseCountChartConfig.PROPERTY_FIELD_ITEMS, mbc.getItem());
        map.put(HlsAnalyseCountChartConfig.PROPERTY_FIELD_HAVE_TITLE, mbc.getHaveTitle());
        map.put(HlsAnalyseCountChartConfig.PROPERTY_FIELD_TITLE, mbc.getTitle());
        map.put(HlsAnalyseCountChartConfig.PROPERTY_FIELD_RIGHT_TITLE, mbc.getRightTitle());
        addConfig(HlsAnalyseCountChartConfig.PROPERTY_FIELD_RIGHT_TITLE, mbc.getRightTitle());
        addConfig(HlsAnalyseCountChartConfig.PROPERTY_FIELD_TITLE, mbc.getTitle());
        addConfig(HlsAnalyseCountChartConfig.PROPERTY_FIELD_STATUS, mbc.getStatus());
        addConfig(HlsAnalyseCountChartConfig.PROPERTITY_BINDTARGET, mbc.getBindTarget());
        addConfig(HlsAnalyseCountChartConfig.PROPERTY_FIELD_CLICK_FUNC, mbc.getClickFunc());
        addConfig(HlsAnalyseCountChartConfig.PROPERTY_FIELD_COLOR, mbc.getColor());
        addConfig(HlsAnalyseCountChartConfig.PROPERTY_FIELD_ITEMS, mbc.getItem());

        if (session.getContextPath() != null)
            map.put(CONFIG_CONTEXT, session.getContextPath());

        map.put(CONFIG, getConfigString());
    }
}
