package com.hand.hls.hlcm.icbc.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.core.impl.ServiceRequest;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import com.hand.hls.hlcm.icbc.dto.EbankWithholdBatch;
import com.hand.hls.hlcm.icbc.dto.JobsHistory;
import com.hand.hls.hlcm.icbc.exception.IcbcException;
import com.hand.hls.hlcm.icbc.formbean.BankBatch;
import com.hand.hls.hlcm.icbc.mapper.EbankWithholdBatchMapper;
import com.hand.hls.hlcm.icbc.mapper.InterfaceRecordMapper;
import com.hand.hls.hlcm.icbc.service.IEbankWithholdBatchService;
import com.hand.hls.hlcm.icbc.service.IInitCommandService;
import com.hand.hls.hlcm.icbc.service.IJobsHistoryService;
import com.hand.hls.hlcm.icbc.utils.IcbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import java.io.PrintWriter;
import java.io.StringWriter;

@Service
public class EbankWithholdBatchServiceImpl extends BaseServiceImpl<EbankWithholdBatch> implements IEbankWithholdBatchService {

    Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private EbankWithholdBatchMapper batchMapper;

    @Autowired
    @Qualifier("initCommandServiceImpl")
    private IInitCommandService initCommandService;

    @Autowired
    private IJobsHistoryService jobsHistoryService;

    @Autowired
    private InterfaceRecordMapper recordMapper;

    @Override
    public void createIcbcJob() {
        JobsHistory jobsHistory = new JobsHistory();
        IRequest request = new ServiceRequest();
        request.setLocale("zh_CN");
        RequestHelper.setCurrentRequest(request);
        jobsHistory.setStatus("SUCCESS");
        JobsHistory history = new JobsHistory();
        try {


            batchMapper.createIcbcJobBatchId(history);

            if (history.getBatchId() == null) {
                throw new IcbcException("未生成batch");
            }

            Long batchId = history.getBatchId();

            try {
                initCommandService.initSendCommand(request, batchId, IcbcUtils.PRODUCT_MODE);
            } catch (Exception e) {

                BankBatch bankBatch = new BankBatch();
                bankBatch.setBatchId(batchId);
                bankBatch.setStatus("POST_FAIL");
                recordMapper.updateBankBatchStatus(bankBatch);
                throw e;
            }

            Thread.sleep(7200000L);
            try {
                initCommandService.initQueryCommand(request, batchId);
            } catch (Exception e) {
                logger.error("第一次查询出错了", e);
                Thread.sleep(2400000L);
                initCommandService.initQueryCommand(request, batchId);
            }
        } catch (Exception e) {
            logger.error("icbc job error:", e);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);

            e.printStackTrace(pw);

            jobsHistory.setStatus("FAIL");
            jobsHistory.setErrorMsg(sw.toString());
        }
        jobsHistoryService.insertSelective(request, jobsHistory);

    }
}