package com.hand.hls.hlcm.acr.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import com.hand.hls.hlcm.acr.dto.AcrEleInvoiceHd;
import com.hand.hls.hlcm.acr.dto.AcrEleInvoiceLn;
import com.hand.hls.hlcm.acr.dto.AcrInvoiceHd;
import com.hand.hls.hlcm.acr.dto.AcrInvoiceLn;
import com.hand.hls.hlcm.acr.mapper.AcrEleInvoiceHdMapper;
import com.hand.hls.hlcm.acr.mapper.AcrEleInvoiceLnMapper;
import com.hand.hls.hlcm.acr.mapper.AcrInvoiceLnMapper;
import com.hand.hls.hlcm.acr.service.IAcrEleInvoiceHdService;
import com.hand.hls.hlcm.acr.service.IAcrEleInvoiceLnService;
import com.hand.hls.hlcm.acr.service.IAcrInvoiceHdService;
import com.hand.hls.hlcm.atm.mapper.HlsFndAtmAttachmentMultiMapper;
import com.hand.hls.hlcm.atm.service.IHlsFndAtmAttachmentMultiService;
import com.hand.hls.hlcm.atm.service.IHlsFndAtmAttachmentService;
import com.hand.hls.hlcm.util.ResMessageException;
import com.hand.hls.hlcm.util.acr.*;
import jodd.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/**
 * @Author Robert8900
 * @Date: 2018/8/24 17:27
 * @Description: 发票 service实现类
 * @Purpose:
 **/
@Service
@Transactional(rollbackFor = Exception.class)
public class AcrInvoiceHdServiceImpl extends BaseServiceImpl<AcrInvoiceHd> implements IAcrInvoiceHdService {
    @Autowired
    private IAcrEleInvoiceHdService iAcrEleInvoiceHdService;
    @Autowired
    private AcrEleInvoiceHdMapper acrEleInvoiceHdMapper;
    @Autowired
    private AcrEleInvoiceLnMapper acrEleInvoiceLnMapper;
    @Autowired
    private AcrInvoiceLnMapper acrInvoiceLnMapper;
    @Autowired
    private IAcrEleInvoiceLnService iAcrEleInvoiceLnService;
    @Autowired
    private IHlsFndAtmAttachmentMultiService iHlsFndAtmAttachmentMultiService;
    @Autowired
    private IHlsFndAtmAttachmentService iHlsFndAtmAttachmentService;

    @Autowired
    private HlsFndAtmAttachmentMultiMapper atmAttachmentMultiMapper;

    Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public ResponseData acrInvoiceInfoSubmit(IRequest iRequest, List<AcrInvoiceHd> list) throws ResMessageException {

        ResponseData responseData = new ResponseData(true);
        //查询发票余量
        //发票余量报文
        String fpylXml = GetKpylXmlUtil.getXml();
        //发送
        JSONObject fpylJsonObject = GetKpylUtil.post(fpylXml);
        System.out.println(fpylXml);
        if ("false".equals(fpylJsonObject.getString("flag"))) {
            responseData.setSuccess(false);
            responseData.setMessage(fpylJsonObject.getString("errorMessage"));
        } else {
            //比较发票余量和这次开票的数量，余量不够不允许开票
            int acrEleNumber = Integer.parseInt(fpylJsonObject.getString("acrEleNumber"));
            if (acrEleNumber < list.size()) {
                responseData.setSuccess(false);
                responseData.setMessage("发票余量不足此次开票，请检查");
            } else {
                for (int i = 0; i < list.size(); i++) {
                    //先把发票头行表信息存到电子发票中间头行表中
                    ResponseData data = null;

                    //先判断这条发票是否已经执行过开票，也就是电子发票中间表是否存在记录
                    AcrEleInvoiceHd eleInvoiceHd = new AcrEleInvoiceHd();
                    eleInvoiceHd.setInvoiceHdId(list.get(i).getInvoiceHdId());

                    List<AcrEleInvoiceHd> eleInvoiceHds = acrEleInvoiceHdMapper.select(eleInvoiceHd);

                    /**
                     * 如果出现"请维护对应的税收分类编码"这种错误，先删掉 acr_ele_invoice_hd 表中这条数据
                     */
                    for(int j = 0; j < eleInvoiceHds.size(); j++){
                        if(eleInvoiceHds.get(j).getErrorMessage().equals("请维护对应的税收分类编码")){
                            long eleId = eleInvoiceHds.get(j).getEleInvoiceHdId();
                            acrEleInvoiceHdMapper.deleteData(eleId);
                        }
                    }
                    //删完之后再重新查询一下
                    eleInvoiceHds = acrEleInvoiceHdMapper.select(eleInvoiceHd);

                    if (eleInvoiceHds.size() == 0) {
                        data = insertEleInvoiceInfo(iRequest, list.get(i));

                        if (data != null){
                            //调用发送接口报文封装类
                            String xml = AcrInfoSubmitXmlUtil.getXml(list.get(i), acrEleInvoiceHdMapper, acrEleInvoiceLnMapper);

                            //调用发送接口工具类
                            JSONObject jsonObject = AcrInfoSubmitUtil.post(xml);

                            if ("false".equals(jsonObject.getString("flag"))) {
//                            responseData.setSuccess(false);
//                            responseData.setMessage(jsonObject.getString("errorMessage"));
//                            throw new ResMessageException(jsonObject.getString("errorMessage"));
                                /**
                                 * 如果开电子发票报错，则把报错信息放入AcrInvoiceHd的Taxcode和Taxmsg
                                 * add by zwg
                                 */
                                String errorCode = jsonObject.getString("statusCode");
                                String errorMessage = jsonObject.getString("errorMessage");

                                AcrInvoiceHd acrInvoiceHd = new AcrInvoiceHd();
                                acrInvoiceHd.setInvoiceHdId(list.get(i).getInvoiceHdId());
                                acrInvoiceHd.setTaxCode(errorCode);
                                acrInvoiceHd.setTaxMsg(errorMessage);
                                //更新电子发票状态，表示已经传入金税接口，并更新错误代码和错误提示
                                acrEleInvoiceHdMapper.updateInvoiceHdErrorStatus(acrInvoiceHd);
                            } else {
                                //更新电子发票状态，表示已经传入金税接口
                                acrEleInvoiceHdMapper.updateAcrEleHdStatus(list.get(i).getInvoiceHdId());

                                //开票成功结束后，更新发票余量
                                int num = acrEleNumber - list.size();
                                Long companyId = iRequest.getCompanyId();
                                AcrEleInvoiceHd acrEleInvoiceHd = new AcrEleInvoiceHd();
                                acrEleInvoiceHd.setAcrEleNumber(num);
                                acrEleInvoiceHd.setCompanyId(companyId);
                                acrEleInvoiceHdMapper.updateAceEleNumber(acrEleInvoiceHd);
                            }
                        }

                    }

                }
            }
        }
        return responseData;
    }


    @Override
    public ResponseData acrInvoiceInfoDownload(IRequest iRequest, List<AcrInvoiceHd> list) throws ResMessageException {
        ResponseData responseData = new ResponseData(true);
        for (int i = 0; i < list.size(); i++) {
            //获取下载电子发票报文
            String xml = AcrInfoDownloadXmlUtil.getXml(list.get(i), acrEleInvoiceHdMapper);
            System.out.println(xml);
            //调用电子发票下载接口(因为发票流水号是唯一的，所以在下载的逻辑里面，通过流水号去匹配，不需要传头ID)
            JSONObject jsonObject = AcrInfoDownloadUtil.post(xml, iRequest, acrEleInvoiceHdMapper, iHlsFndAtmAttachmentMultiService, iHlsFndAtmAttachmentService, atmAttachmentMultiMapper);

            if ("false".equals(jsonObject.getString("flag"))) {
                responseData.setSuccess(false);
                responseData.setMessage(jsonObject.getString("errorMessage"));
                throw new ResMessageException(jsonObject.getString("errorMessage"));
            }
        }
        return responseData;
    }

    /**
     *
     * 如果是以下报错，则插入acr_invoice_hd
     * 1。开电子发票没有存在开票手机号码
     * 2。电子发票只能开普票
     * 3。开票人名称过长，不符合
     * 如果是以下报错，则插入acr_ele_invoice_hd
     *    没有对应的税收分类编码
     * 因为税收编码是关联在现金流表里，无法拆到acr_invoice_hd
     *
     */
    public ResponseData insertEleInvoiceInfo(IRequest iRequest, AcrInvoiceHd acrInvoiceHd) {
        ResponseData responseData = new ResponseData(true);
        String saleTax = "";
        try {
            Properties properties = new Properties();
            InputStream is = PropertiesUtil.class.getClassLoader()
                    .getResourceAsStream("config.properties");
            properties.load(is);
            saleTax = properties.getProperty("acr.saleTax");
        } catch (Exception e) {
            e.printStackTrace();
        }

        AcrInvoiceHd hd = new AcrInvoiceHd();
        hd = self().selectByPrimaryKey(iRequest, acrInvoiceHd);

        //先判断这条发票是否已经执行过开票，也就是电子发票中间表是否存在记录
        AcrEleInvoiceHd eleInvoiceHd = new AcrEleInvoiceHd();
        eleInvoiceHd.setInvoiceHdId(hd.getInvoiceHdId());
        List<AcrEleInvoiceHd> eleInvoiceHds = acrEleInvoiceHdMapper.select(eleInvoiceHd);

        if (eleInvoiceHds.size() > 0) {
            return responseData;
        } else {
            //流水号
            String swno = acrEleInvoiceHdMapper.getSwnoDocumentNumber(iRequest.getUserId(), iRequest.getCompanyId());
            //购货方企业类型
            String bpClass = acrEleInvoiceHdMapper.getBpClass(hd.getBpId());
            String custType = "";
            if ("NP".equals(bpClass)) {
                // 03 代表个人
                custType = "03";
            } else {
                // 01 代表法人
                custType = "01";
            }
            //获取电话号码
            String custTelephone = acrEleInvoiceHdMapper.getCellPhone(hd.getBpId());
            // if ("03".equals(custType)) {
            if ("".equals(custTelephone) || custTelephone == null) {
                    /*responseData.setSuccess(false);
                    responseData.setMessage("开个人电子发票必须存在手机号码");
                    return responseData;*/
                //update by zhuxianfei 20181228
                //throw new CallException("开电子发票必须存在手机号码");
                /**
                 * 如果开电子发票报错，则把报错信息放入AcrInvoiceHd的Taxcode和Taxmsg
                 * add by zwg
                 */
                String errorCode = "";
                String errorMessage = "开电子发票必须存在手机号码";

                AcrInvoiceHd a = new AcrInvoiceHd();
                a.setInvoiceHdId(hd.getInvoiceHdId());
                a.setTaxCode(errorCode);
                a.setTaxMsg(errorMessage);
                //更新电子发票状态，表示已经传入金税接口，并更新错误代码和错误提示
                acrEleInvoiceHdMapper.updateInvoiceHdErrorStatus(a);
                return null;
            }
            // }
            //获取邮箱
            String email = acrEleInvoiceHdMapper.getEmail(hd.getBpId());

            //判断发票类型，如果是专票，不允许开
            if ("0".equals(hd.getInvoiceKind())) {
               /* responseData.setSuccess(false);
                responseData.setMessage("电子发票只能开普票");
                return responseData;*/
                //update by zhuxianfei 20181228
//                throw new CallException("电子发票只能开普票");
                /**
                 * 如果开电子发票报错，则把报错信息放入AcrInvoiceHd的Taxcode和Taxmsg
                 * add by zwg
                 */
                String errorCode = "";
                String errorMessage = "电子发票只能开普票";

                AcrInvoiceHd a = new AcrInvoiceHd();
                a.setInvoiceHdId(hd.getInvoiceHdId());
                a.setTaxCode(errorCode);
                a.setTaxMsg(errorMessage);
                //更新电子发票状态，表示已经传入金税接口，并更新错误代码和错误提示
                acrEleInvoiceHdMapper.updateInvoiceHdErrorStatus(a);
                return null;

            }

            //获取开票人名称
            String name = acrEleInvoiceHdMapper.getName(iRequest.getUserId());
            System.out.println(name.length());
            if (name.length() > 4) {
//                throw new CallException("开票人名称过长，不符合");
                /**
                 * 如果开电子发票报错，则把报错信息放入AcrInvoiceHd的Taxcode和Taxmsg
                 * add by zwg
                 */
                String errorCode = "";
                String errorMessage = "开票人名称过长，不符合";

                AcrInvoiceHd a = new AcrInvoiceHd();
                a.setInvoiceHdId(hd.getInvoiceHdId());
                a.setTaxCode(errorCode);
                a.setTaxMsg(errorMessage);
                //更新电子发票状态，表示已经传入金税接口，并更新错误代码和错误提示
                acrEleInvoiceHdMapper.updateInvoiceHdErrorStatus(a);
                return null;
            }

            //插入电子发票中间头表
            AcrEleInvoiceHd acrEleInvoiceHd = new AcrEleInvoiceHd();
            acrEleInvoiceHd.setInvoiceHdId(hd.getInvoiceHdId());
            acrEleInvoiceHd.setDocumentType("ACR_ELE_INVOICE");
            acrEleInvoiceHd.setDocumentCategory("ACR_ELE_INVOICE");
            acrEleInvoiceHd.setSwno(swno);  //流水号
            acrEleInvoiceHd.setSaleTax(saleTax);
            acrEleInvoiceHd.setCustName(hd.getBpName());
            acrEleInvoiceHd.setCustTaxNo(hd.getBpTaxRegistryNum());
            acrEleInvoiceHd.setCustAddr(hd.getBpAddressPhoneNum());
            acrEleInvoiceHd.setCustTelephone(custTelephone);
            acrEleInvoiceHd.setCustPhone("");
            acrEleInvoiceHd.setCustEmail(email);
            acrEleInvoiceHd.setCustBankAccount(hd.getBpBankAccount());
            acrEleInvoiceHd.setCustType(custType);
            acrEleInvoiceHd.setInvoMemo(hd.getDescription());
            //acrEleInvoiceHd.setInvType(hd.getInvoiceKind());
            acrEleInvoiceHd.setInvType("3");
            acrEleInvoiceHd.setBillDate(new Date());
            acrEleInvoiceHd.setThdh("");
            acrEleInvoiceHd.setBillType(1L);  //1代表开正票
            acrEleInvoiceHd.setSpecialRedFlag("0");   //默认0  代表正常冲红，电子发票
            acrEleInvoiceHd.setOperationCode("10");   //正票正常开具
            acrEleInvoiceHd.setKpy(name);  //用户名称
            //acrEleInvoiceHd.setSky(name);  //同开票人
            acrEleInvoiceHd.setSky("孟晓燕");  //写死
            //acrEleInvoiceHd.setSky(Skr);  //开票人
            acrEleInvoiceHd.setFhr(name);  //同开票人
            acrEleInvoiceHd.setYfpdm("");  //原发票代码 红冲使用，这里是空
            acrEleInvoiceHd.setYfphm("");  //原发票号码 红冲使用，这里是空
            acrEleInvoiceHd.setChyy("0");  //正常票填0
            acrEleInvoiceHd.setStatus("NEW");
            acrEleInvoiceHd = iAcrEleInvoiceHdService.insertSelective(iRequest, acrEleInvoiceHd);

            //插入电子发票中间行表
            List<AcrInvoiceLn> acrInvoiceLns = acrInvoiceLnMapper.selectAcrInvoiceLnDetail(hd.getInvoiceHdId());
            for (int i = 0; i < acrInvoiceLns.size(); i++) {
                //获取合同ID和合同编号
                List<Map> list = acrEleInvoiceHdMapper.getContractDetail(acrInvoiceLns.get(i).getCashflowId());
                //获取税收分类编码
                AcrEleInvoiceHd invoiceHd = new AcrEleInvoiceHd();
                invoiceHd.setCashflowId(acrInvoiceLns.get(i).getCashflowId());
                invoiceHd.setCfType(acrInvoiceLns.get(i).getCfType());
                String code = acrEleInvoiceHdMapper.getTaxClassNum(invoiceHd);
                //update by zhuxianfei 20181228
                if ("".equals(code) || code == null) {

//                    throw new CallException("请维护对应的税收分类编码");

                    String errorCode = "";
                    String errorMessage = "请维护对应的税收分类编码";

                    acrEleInvoiceHd.setInvoiceHdId(hd.getInvoiceHdId());
                    acrEleInvoiceHd.setErrorCode(errorCode);
                    acrEleInvoiceHd.setErrorMessage(errorMessage);
                    //更新电子发票状态，表示已经传入金税接口，并更新错误代码和错误提示
                    acrEleInvoiceHdMapper.updateAcrEleHdErrorStatus(acrEleInvoiceHd);
                    return null;
                }

                AcrEleInvoiceLn acrEleInvoiceLn = new AcrEleInvoiceLn();
                acrEleInvoiceLn.setEleInvoiceHdId(acrEleInvoiceHd.getEleInvoiceHdId());
                acrEleInvoiceLn.setInvoiceHdId(acrInvoiceLns.get(i).getInvoiceHdId());
                acrEleInvoiceLn.setInvoiceLnId(acrInvoiceLns.get(i).getInvoiceLnId());
                acrEleInvoiceLn.setContractId(Long.valueOf(String.valueOf(list.get(0).get("contractId"))));
                acrEleInvoiceLn.setCashflowId(acrInvoiceLns.get(i).getCashflowId());
                acrEleInvoiceLn.setBillNo(String.valueOf(list.get(0).get("contractNumber")));
                acrEleInvoiceLn.setName(acrInvoiceLns.get(i).getProductName());
                acrEleInvoiceLn.setCode(code); //税收分类编码
                acrEleInvoiceLn.setLineType("0");
                acrEleInvoiceLn.setSpec(acrInvoiceLns.get(i).getSpecification());
                //acrEleInvoiceLn.setUnit(acrInvoiceLns.get(i).getUom());
                acrEleInvoiceLn.setUnit("台");
                acrEleInvoiceLn.setTaxRate(acrInvoiceLns.get(i).getTaxTypeRate());
                acrEleInvoiceLn.setQuantity(acrInvoiceLns.get(i).getQuantity());
                acrEleInvoiceLn.setTaxPrice(acrInvoiceLns.get(i).getPrice());
                acrEleInvoiceLn.setTotalAmount(acrInvoiceLns.get(i).getTotalAmount());
                acrEleInvoiceLn.setYhzcbs("0");
                acrEleInvoiceLn.setYhzcnr("");
                acrEleInvoiceLn.setLslbs(null);
                acrEleInvoiceLn.setZxbm("");
                acrEleInvoiceLn.setKce(null);
                iAcrEleInvoiceLnService.insertSelective(iRequest, acrEleInvoiceLn);
            }
        }
        return responseData;
    }
}
