WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool CUS_DEPOSIT_CALC_OVERDUE_TMP.log

PROMPT
PROMPT CREATING TABLE CUS_DEPOSIT_CALC_OVERDUE_TMP
PROMPT ============================
PROMPT
WHENEVER SQLERROR CONTINUE
 DROP TABLE CUS_DEPOSIT_CALC_OVERDUE_TMP;
WHENEVER SQLERROR EXIT FAILURE ROLLBACK

-- Create table
create table CUS_DEPOSIT_CALC_OVERDUE_TMP
(
  calc_id             NUMBER not null,
  session_id          NUMBER,
  calc_date           DATE,
  due_date            DATE,
  contract_id         NUMBER,
  cashflow_id         NUMBER,
  f_overdue_amount    NUMBER,
  f_overdue_penalty_amt NUMBER,
  overdue_principal   NUMBER,
  overdue_interest    NUMBER,
  overdue_amount      NUMBER,
  overdue_max_days    NUMBER,
  overdue_penalty_amt NUMBER,
  created_by          NUMBER,
  creation_date       DATE
);
-- Add comments to the table
comment on table CUS_DEPOSIT_CALC_OVERDUE_TMP
  is '保证金代垫清单-罚息测算';

-- Add comments to the columns
comment on column CUS_DEPOSIT_CALC_OVERDUE_TMP.calc_id
  is 'PK';
comment on column CUS_DEPOSIT_CALC_OVERDUE_TMP.session_id
  is 'session_id';
comment on column CUS_DEPOSIT_CALC_OVERDUE_TMP.calc_date
  is '计算日';
comment on column CUS_DEPOSIT_CALC_OVERDUE_TMP.due_date
  is '到期日';
comment on column CUS_DEPOSIT_CALC_OVERDUE_TMP.contract_id
  is '合同id';
comment on column CUS_DEPOSIT_CALC_OVERDUE_TMP.cashflow_id
  is '现金流id';
comment on column CUS_DEPOSIT_CALC_OVERDUE_TMP.overdue_principal
  is '逾期本金';
comment on column CUS_DEPOSIT_CALC_OVERDUE_TMP.overdue_interest
  is '逾期利息';
comment on column CUS_DEPOSIT_CALC_OVERDUE_TMP.overdue_amount
  is '逾期租金';
comment on column CUS_DEPOSIT_CALC_OVERDUE_TMP.overdue_max_days
  is '最大逾期天数';
comment on column CUS_DEPOSIT_CALC_OVERDUE_TMP.overdue_penalty_amt
  is '逾期违约金';

-- Create/Recreate indexes
create index CUS_DEPT_CALC_OVERDUE_TMP_N1 on CUS_DEPOSIT_CALC_OVERDUE_TMP (SESSION_ID);
create index CUS_DEPT_CALC_OVERDUE_TMP_N2 on CUS_DEPOSIT_CALC_OVERDUE_TMP (CONTRACT_ID);
-- Create/Recreate primary, unique and foreign key constraints
alter table CUS_DEPOSIT_CALC_OVERDUE_TMP
  add constraint CUS_DEPT_CALC_OVERDUE_TMP_PK primary key (CALC_ID);

/
SPOOL OFF

EXIT