package com.hand.hls.hlcm.util.aes.controllers;

import leaf.bean.LeafRequestData;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hls.hlcm.util.aes.service.AesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.IOException;
import java.util.Map;

/**
 * Copyright (C) Hand Business Consulting Services
 * AllRights Reserved
 *
 * @Auther: Eugene Song
 * @Date: 2018/10/4 11:24
 * @Description: AES128 算法，加密模式为ECB，填充模式为 pkcs5
 */
@Controller
public class AesController extends BaseController {
    @Autowired
    private AesService service;


    //加密
    @RequestMapping(value = "/aes/encrypt")
    @ResponseBody
    public ResponseData encrypt(@ModelAttribute(LEAF_PARAM_NAME) LeafRequestData requestData) {
        Map parameter = requestData.getParameter();
        String content = (String) parameter.get("content");
        ResponseData responseData = new ResponseData();
        content = service.Encrypt(content);
        responseData.setSuccess(true);
        responseData.setMessage(content);
        return responseData;
    }


    //解密
    @RequestMapping(value = "/aes/decrypt")
    @ResponseBody
    public ResponseData Decrypt(@ModelAttribute(LEAF_PARAM_NAME) LeafRequestData requestData) {
        Map parameter = requestData.getParameter();
        String content = (String) parameter.get("content");
        ResponseData responseData = new ResponseData();
        content = service.Decrypt(content);
        responseData.setSuccess(true);
        responseData.setMessage(content);
        return responseData;
    }

}
