package com.hand.hls.hlcm.icbc.job;

import com.hand.hap.core.IRequest;
import com.hand.hap.core.impl.RequestHelper;
import com.hand.hap.core.impl.ServiceRequest;
import com.hand.hls.hlcm.icbc.dto.QuartzJob;
import com.hand.hls.hlcm.icbc.dto.QuartzJobHistory;
import com.hand.hls.hlcm.icbc.exception.JobException;
import com.hand.hls.hlcm.icbc.mapper.InterfaceRecordMapper;
import com.hand.hls.hlcm.icbc.mapper.QuartzJobHistoryMapper;
import com.hand.hls.hlcm.icbc.mapper.QuartzJobMapper;
import com.hand.hls.hlcm.icbc.service.IInitCommandService;
import com.hand.hls.hlcm.icbc.service.IQuartzJobHistoryService;
import com.hand.hls.hlcm.icbc.utils.HostUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.List;

/**
 * @description: daily job
 * @author: huangtianyang
 * @create: 2019-01-02 20:31
 **/

public class IcbcInterfaceJob {

    @Autowired
    private QuartzJobMapper quartzJobMapper;

    @Autowired
    private QuartzJobHistoryMapper quartzJobHistoryMapper;

    @Autowired
    private IQuartzJobHistoryService historyService;

    @Autowired
    @Qualifier("initCommandServiceImpl")
    private IInitCommandService initCommandService;

    @Autowired
    private InterfaceRecordMapper recordMapper;

    private static String STATUS_EXCUTION = "1";

    private static String STATUS_END = "0";

    private String JOB_CODE = "IcbcInterfaceJob";

    private Logger logger = LoggerFactory.getLogger(getClass());

    //仅可以用于每天只执行一次的job
    private QuartzJob start(String jobCode) throws JobException {
        QuartzJob job = new QuartzJob();
        job.setEnableFlag("Y");
        job.setJobCode(jobCode);
        job.setCreationDate(new Date());
        job.setJobStatus(STATUS_END);
        List<QuartzJob> jobs = quartzJobMapper.select(job);
        if (CollectionUtils.isEmpty(jobs)) {
            throw new JobException("there is no enabled job");
        }
        job.setJobId(jobs.get(0).getJobId());
        //状态进入执行
        int updates = quartzJobMapper.startJob(job);
        //是否修改
        if (updates < 1) {
            throw new JobException("there is no enabled job");
        }
        job.setJobStatus(STATUS_EXCUTION);


        return job;
    }

    private void end(QuartzJob job) {
        quartzJobMapper.endJob(job);
    }


    private void executing() throws Exception {
        System.out.println(new Date().toString());
        IRequest request = new ServiceRequest();
        request.setLocale("zh_CN");
        RequestHelper.setCurrentRequest(request);

        List<Long> batchIds = recordMapper.queryBatchIdForJob();

        if (CollectionUtils.isEmpty(batchIds)) {
            logger.debug("We don't have batch to submit today.");
            return;
        }
        Long batchId = batchIds.get(0);

        System.out.println(new Date().toString());

//        initCommandService.initSendCommand(request, batchId, IcbcUtils.PRODUCT_MODE);

//        initCommandService.initQueryCommand(request, batchId);


    }

    private void record(QuartzJob job, QuartzJobHistory history) {
        history.setJobId(job.getJobId());
        IRequest request = new ServiceRequest();
        request.setLocale("zh_CN");
        RequestHelper.setCurrentRequest(request);
        history = historyService.insertSelective(request, history);
        history.setExcutionStatus("Y");
    }


    public void execute() {
        QuartzJob job = new QuartzJob();
        QuartzJobHistory history = new QuartzJobHistory();
        try {
            job = start(JOB_CODE);


            record(job, history);

            executing();


            end(job);
        } catch (JobException e) {
            logger.debug(e.getMessage());
        } catch (Exception e) {
            logger.error("do job wrong:{}\n", e);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);

            e.printStackTrace(pw);
            history.setErrorMsg(sw.toString());
            history.setExcutionStatus("N");

        } finally {
            if (STATUS_EXCUTION.equals(job.getJobStatus())) {
                try {
                    history.setHostIp(HostUtils.getLocalHostLANAddress().getHostAddress());
                } catch (Exception e) {
                    logger.debug("can not get hostIp:{}", e);
                }
                quartzJobHistoryMapper.finishHistory(history);
            }
        }
    }
}
