package com.hand.hls.hlcm.sys.formbean;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.github.pagehelper.Page;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;

/**
 * Created with IntelliJ IDEA.
 * Description: A new responseData for Hls3v 0v0
 * User: huangtianyang
 * Date: 2018-08-21
 * Time: 下午2:12
 */
public class LeafResponseData {
    // 返回状态编码
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String code;

    // 返回信息
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String message;

    // 成功标识
    private boolean success = true;

    private LeafResult result;

    public LeafResponseData() {

    }

    public LeafResponseData(Boolean success) {
        setSuccess(success);
    }

    public LeafResponseData(List<?> list) {
        this(true);
        if (CollectionUtils.isNotEmpty(list)) {
            if (list.size() > 1) {
                setResult(new LeafResult(list));
            } else {
                setResult(new LeafResult(list.get(0)));
            }
            if (list instanceof Page){
                getResult().setTotalCount(((Page<?>) list).getTotal());
            }
        } else {
            setResult(new LeafResult());
            getResult().setTotalCount(0L);
        }
    }

    public LeafResult getResult() {
        return result;
    }

    public void setResult(LeafResult result) {
        this.result = result;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

}
