/*
 * Decompiled with CFR 0.152.
 */
package hl.mail;

import hl.mail.HlMailBean;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class HlSendMail {
    public String toChinese(String text) {
        try {
            text = MimeUtility.encodeText((String)new String(text.getBytes(), "GB2312"), (String)"GB2312", (String)"B");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return text;
    }

    public boolean sendMail(HlMailBean mb) throws GeneralSecurityException {
        String host = mb.getHost();
        int port = mb.getPort();
        final String username = mb.getUsername();
        final String password = mb.getPassword();
        String from = mb.getFrom();
        String to = mb.getTo();
        String cc = mb.getCc();
        String subject = mb.getSubject();
        String content = mb.getContent();
        String fileName = mb.getFilename();
        Vector<String> file = mb.getFile();
        Properties props = System.getProperties();
        props.put("mail.smtp.host", host);
        props.put("mail.smtp.port", (Object)port);
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", "true");
        props.put("mail.smtp.socketFactory.fallback", "true");
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        });
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(from));
            InternetAddress[] address = new InternetAddress[]{new InternetAddress(to)};
            msg.setRecipients(Message.RecipientType.TO, (Address[])address);
            if (cc != null) {
                InternetAddress[] ccAddress = new InternetAddress[]{new InternetAddress(cc)};
                msg.setRecipients(Message.RecipientType.CC, (Address[])ccAddress);
            }
            msg.setSubject(this.toChinese(subject));
            MimeMultipart mp = new MimeMultipart();
            MimeBodyPart mbpContent = new MimeBodyPart();
            mbpContent.setText(content);
            mp.addBodyPart((BodyPart)mbpContent);
            if (file != null) {
                Enumeration<String> efile = file.elements();
                while (efile.hasMoreElements()) {
                    MimeBodyPart mbpFile = new MimeBodyPart();
                    fileName = efile.nextElement().toString();
                    FileDataSource fds = new FileDataSource(fileName);
                    mbpFile.setDataHandler(new DataHandler((DataSource)fds));
                    mbpFile.setFileName(this.toChinese(fds.getName()));
                    mp.addBodyPart((BodyPart)mbpFile);
                }
                System.out.println("\u6dfb\u52a0\u6210\u529f");
            }
            msg.setContent((Multipart)mp);
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
        }
        catch (MessagingException me) {
            me.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean sendHtmlMail(HlMailBean mb) throws GeneralSecurityException {
        String host = mb.getHost();
        final String username = mb.getUsername();
        final String password = mb.getPassword();
        String from = mb.getFrom();
        String to = mb.getTo();
        String cc = mb.getCc();
        String subject = mb.getSubject();
        String content = mb.getContent();
        String fileName = mb.getFilename();
        Vector<String> file = mb.getFile();
        Properties props = System.getProperties();
        props.put("mail.smtp.host", host);
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", "true");
        props.put("mail.smtp.socketFactory.fallback", "true");
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        });
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(from));
            InternetAddress[] address = new InternetAddress[]{new InternetAddress(to)};
            InternetAddress[] ccAddress = new InternetAddress[]{new InternetAddress(cc)};
            msg.setRecipients(Message.RecipientType.TO, (Address[])address);
            msg.setRecipients(Message.RecipientType.CC, (Address[])ccAddress);
            msg.setSubject(this.toChinese(subject));
            MimeMultipart mp = new MimeMultipart();
            MimeBodyPart mbpContent = new MimeBodyPart();
            mbpContent.setContent((Object)content, "text/html; charset=utf-8");
            mp.addBodyPart((BodyPart)mbpContent);
            if (file != null) {
                Enumeration<String> efile = file.elements();
                while (efile.hasMoreElements()) {
                    MimeBodyPart mbpFile = new MimeBodyPart();
                    fileName = efile.nextElement().toString();
                    FileDataSource fds = new FileDataSource(fileName);
                    mbpFile.setDataHandler(new DataHandler((DataSource)fds));
                    mbpFile.setFileName(this.toChinese(fds.getName()));
                    mp.addBodyPart((BodyPart)mbpFile);
                }
                System.out.println("\u6dfb\u52a0\u6210\u529f");
            }
            msg.setContent((Multipart)mp);
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
        }
        catch (MessagingException me) {
            me.printStackTrace();
            return false;
        }
        return true;
    }
}

