package com.hand.hls.hlcm.util.acr;

import com.alibaba.fastjson.JSONObject;
import com.hand.hap.core.IRequest;
import com.hand.hls.hlcm.acr.mapper.AcrEleInvoiceHdMapper;
import com.hand.hls.hlcm.atm.dto.HlsFndAtmAttachment;
import com.hand.hls.hlcm.atm.dto.HlsFndAtmAttachmentMulti;
import com.hand.hls.hlcm.atm.mapper.HlsFndAtmAttachmentMultiMapper;
import com.hand.hls.hlcm.atm.service.IHlsFndAtmAttachmentMultiService;
import com.hand.hls.hlcm.atm.service.IHlsFndAtmAttachmentService;
import jodd.util.PropertiesUtil;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Properties;

/**
 * @Author Robert8900
 * @Date: 2018/8/28 10:40
 * @Description: 发票下载接口 调用post工具类
 * @Purpose:
 **/
public class AcrInfoDownloadUtil {
    private static String returnNode = "return";   //return节点
    private static String msgCodeNode = "msgCode"; //msgCode节点
    private static String msgNode = "msg";          //msg节点
    private static String swnoNode = "swno";        //swno节点
    private static String fpdmNode = "fpdm";        //fpdm节点
    private static String fphmNode = "fphm";        //fphm节点
    private static String pdfUrlNode = "pdf_url";   //pdf_url节点
    private static String code = "0000";            //返回结果 0000 成功

    private static  String nodeName = "";
    private static  String returnStr = "";
    private static  String msgCode = "";    //返回code
    private static  String msg = "";        //异常信息(如果msgCode = '0000'表示无异常，则为空)
    private static  String swno = "";      //流水号
    private static  String fpdm = "";     //发票代码
    private static  String fphm = "";     //发票号码
    private static  String pdfUrl = "";   //pdf URL

    //调用接口
    public static JSONObject post(String xml, IRequest iRequest, AcrEleInvoiceHdMapper acrEleInvoiceHdMapper, IHlsFndAtmAttachmentMultiService iHlsFndAtmAttachmentMultiService, IHlsFndAtmAttachmentService iHlsFndAtmAttachmentService, HlsFndAtmAttachmentMultiMapper atmAttachmentMultiMapper)  {
        String  acrWsdlUrl = "";
        String  pdfAddress = "";
        try {
            Properties properties = new Properties();
            InputStream is = PropertiesUtil.class.getClassLoader()
                    .getResourceAsStream("config.properties");
            properties.load(is);
            acrWsdlUrl = properties.getProperty("acr.webservice.url");
            pdfAddress = properties.getProperty("acr.pdfAddress");
        }catch (Exception e){
            e.printStackTrace();
        }

        JSONObject jsonObject = new JSONObject();
        HttpClient client = new HttpClient();
        PostMethod myPost = new PostMethod(acrWsdlUrl);
        client.getParams().setSoTimeout(60*1000);
        try{
            myPost.setRequestEntity(new StringRequestEntity(xml,"text/xml","utf-8"));
            int statusCode = client.executeMethod(myPost);
            if(statusCode == HttpStatus.SC_OK){
                BufferedInputStream bis = new BufferedInputStream(myPost.getResponseBodyAsStream());
                byte[] bytes = new byte[1024];
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                int count = 0;
                while((count = bis.read(bytes))!= -1){
                    bos.write(bytes, 0, count);
                }
                byte[] strByte = bos.toByteArray();
                //解析返回的数据
                String responseString = new String(strByte,0,strByte.length,"utf-8");
                readInputStream(responseString);
                if(code.equals(msgCode)){
                    //解析url，并且下载pdf
                    downloadFile(pdfUrl,pdfAddress,swno + ".pdf");
                    //下载到服务器磁盘之后，更新发票信息到主表，然后把服务器上面的附件关联上主表
                    //第一步，更新信息回主表
                    System.out.println(pdfUrl);
                    acrEleInvoiceHdMapper.updateAceEleHdInfo(swno,fpdm,fphm,pdfUrl);
                    //第二步，把附件关联上电子发票主表
                    HlsFndAtmAttachmentMulti hlsFndAtmAttachmentMulti = new HlsFndAtmAttachmentMulti();
                    //先找到swno对应的 电子发票头表ID
                    Long eleInvoiceHdId = acrEleInvoiceHdMapper.getEleInvoiceHdId(swno);
                    hlsFndAtmAttachmentMulti.setTableName("ACR_ELE_INVOICE_HD");
                    hlsFndAtmAttachmentMulti.setTablePkValue(eleInvoiceHdId);
                    hlsFndAtmAttachmentMulti = iHlsFndAtmAttachmentMultiService.insertSelective(iRequest,hlsFndAtmAttachmentMulti);


                    HlsFndAtmAttachment hlsFndAtmAttachment = new HlsFndAtmAttachment();
                    hlsFndAtmAttachment.setSourceTypeCode("fnd_atm_attachment_multi");
                    hlsFndAtmAttachment.setSourcePkValue(String.valueOf(hlsFndAtmAttachmentMulti.getRecordId()));
                    hlsFndAtmAttachment.setFileTypeCode("pdf");
                    hlsFndAtmAttachment.setMimeType("application/pdf");
                    hlsFndAtmAttachment.setFileName(swno + ".pdf");
                    Long fileSize = 0L;
                    File file = new File(pdfAddress + swno + ".pdf");
                    if (file.exists() && file.isFile()) {
                        fileSize = file.length();
                    }
                    hlsFndAtmAttachment.setFileSize(fileSize);
                    hlsFndAtmAttachment.setFilePath(pdfAddress + swno + ".pdf");
                    hlsFndAtmAttachment.setInterfaceFlag("Y");
                    hlsFndAtmAttachment = iHlsFndAtmAttachmentService.insertSelective(iRequest,hlsFndAtmAttachment);

                    hlsFndAtmAttachmentMulti.setAttachmentId(hlsFndAtmAttachment.getAttachmentId());
                    atmAttachmentMultiMapper.updateAttachmentMulti(hlsFndAtmAttachmentMulti);

                    jsonObject.put("flag", "true");
                }else{
                    jsonObject.put("flag", "false");
                    jsonObject.put("errorMessage", msg);
                }
                bos.close();
                bis.close();
            }else{
                jsonObject.put("flag", "false");
                jsonObject.put("errorMessage", "调用接口异常" + statusCode);
            }
            myPost.releaseConnection();
            client.getHttpConnectionManager().closeIdleConnections(0);
        }catch (Exception e) {
            e.printStackTrace();
            jsonObject.put("flag", "false");
            jsonObject.put("errorMessage", e.getMessage());
        }
        return jsonObject;
    }

    private static void readInputStream(String responseString){
        try{
            //先截取 return节点后面的内容
            Document document = DocumentHelper.parseText(responseString);
            final Element root = document.getRootElement();
            getNodes(root);

            //然后把return后面的内容继续分析
            if(returnNode.equals(nodeName)){
                Document doc = DocumentHelper.parseText(returnStr);
                final Element element = doc.getRootElement();
                analysisXml(element);
            }
        }catch(Exception e){
            e.printStackTrace();
        }
    }

    private static void  getNodes(final Element node) {
        if(returnNode.equals(node.getName())){
            nodeName = node.getName();
            returnStr = node.getTextTrim();
        }
        final List<Element> listElement = node.elements();// 所有一级子节点的list
        for (final Element e : listElement) {// 遍历所有一级子节点
            getNodes(e);// 递归
        }
    }

    public static void analysisXml(final Element node) {
        if(msgCodeNode.equals(node.getName())){
            msgCode = node.getTextTrim();
        }
        if(msgNode.equals(node.getName())){
            msg = node.getTextTrim();
        }
        if(swnoNode.equals(node.getName())){
            swno = node.getTextTrim();
        }
        if(fpdmNode.equals(node.getName())){
            fpdm = node.getTextTrim();
        }
        if(fphmNode.equals(node.getName())){
            fphm = node.getTextTrim();
        }
        if(pdfUrlNode.equals(node.getName())){
            pdfUrl = node.getTextTrim();
        }
        final List<Element> listElement = node.elements();// 所有一级子节点的list
        for (final Element e : listElement) {// 遍历所有一级子节点
            analysisXml(e);// 递归
        }
    }

    public static void downloadFile(String urlPath, String downloadDir, String fileName) {
        File file = null;
        try {
            // 统一资源
            URL url = new URL(urlPath);
            // 连接类的父类，抽象类
            URLConnection urlConnection = url.openConnection();
            // http的连接类
            HttpURLConnection httpURLConnection = (HttpURLConnection) urlConnection;
            // 设定请求的方法，默认是GET
            httpURLConnection.setRequestMethod("GET");
            // 设置字符编码
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            // 打开到此 URL 引用的资源的通信链接（如果尚未建立这样的连接）。
            httpURLConnection.connect();
            // 文件大小
            int fileLength = httpURLConnection.getContentLength();
            // 文件
            BufferedInputStream bin = new BufferedInputStream(httpURLConnection.getInputStream());

            String path = downloadDir + File.separatorChar + fileName;
            file = new File(path);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            OutputStream out = new FileOutputStream(file);

            int size = 0;
            int len = 0;
            byte[] buf = new byte[1024];
            while ((size = bin.read(buf)) != -1) {
                len += size;
                out.write(buf, 0, size);
            }
            bin.close();
            out.close();
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

    }
}
