package com.hand.hls.hlcm.baofoo.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hls.hlcm.baofoo.dto.BaofooResponse;
import com.hand.hls.hlcm.baofoo.service.IBaofooResponseService;
import com.hand.hls.hlcm.baofoo.service.IBaofooService;
import com.hand.hls.hlcm.baofoo.utils.*;
import com.hand.hls.hlcm.icbc.utils.DoubleUtil;
import com.hand.hls.hlcm.util.ResMessageException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.*;

@Service
@Transactional(rollbackFor = Exception.class)
public class BaofooServiceImpl implements IBaofooService {

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Value("${baofoo.memberid:100000276}")
    private String memberId;

    @Value("${baofoo.terminal_id:100000990}")
    private String terminalId;

    @Value("${baofoo.pfxpwd:123456}")
    private String pfxpwd;

    @Value("${baofoo.pfxpath:bfkey_100000276@@100000990.pfx}")
    private String pfxPath;

    @Value("${baofoo.pfxpath:bfkey_100000276@@100000990.cer}")
    private String cerPath;

    private static final String payUrl = "https://vgw.baofoo.com/cutpayment/api/backTransRequest";


    @Autowired
    private IBaofooResponseService baofooResponseService;

    @Override
    public ResponseData apiPay(IRequest iRequest, String payCode, String accNo, String idCard, String idHolder, String mobile, String amount, Long responseId) throws Exception {

        Map<String, String> headPostParam = FormUtil.getParams(memberId, terminalId);//明文参数
        headPostParam.put("txn_sub_type", "83"); //交易子类（代扣）
        String dataContent = getPayDataContent(headPostParam, payCode, accNo, idCard, idHolder, mobile, amount);
        headPostParam.put("data_content", dataContent);//加入请求密文

        HttpClient httpclient = new DefaultHttpClient();
        ResponseData responseData = new ResponseData();
        try {
            HttpResponse response = httpclient.execute(initPost(headPostParam, payUrl));
            int code = response.getStatusLine().getStatusCode();
            if (HttpStatus.SC_OK == code) {

                String PostString = EntityUtils.toString(response.getEntity(), "utf-8");
                String cerpath = URLDecoder.decode(getClass().getClassLoader().getResource(cerPath).getPath(), "utf-8");
                PostString = RsaCodingUtil.decryptByPubCerFile(PostString, cerpath);
                if (StringUtils.isEmpty(PostString)) {
                    throw new RuntimeException("私钥文件有误");
                }
                PostString = SecurityUtil.Base64Decode(PostString);
                logger.debug("response 明文{}", PostString);

//                JSONObject.parseObject(PostString).toCa
                BaofooResponse baofooResponse = ((JSONObject) JsonUtils.convert(PostString)).toJavaObject(BaofooResponse.class);
                baofooResponse.setDueAmount(Double.valueOf(amount));
                baofooResponse.setPayCode(payCode);
                baofooResponse.setAccNo(accNo);
                baofooResponse.setIdCard(idCard);
                baofooResponse.setIdHolder(idHolder);
                baofooResponse.setMobile(mobile);
                baofooResponse.setResponseId(responseId);
                baofooResponse.setStatus("回传");
                Double succAmt = baofooResponse.getSuccAmt() == null ? null : DoubleUtil.div(baofooResponse.getSuccAmt(), 100D, 2);
                baofooResponse.setSuccAmt(succAmt);
                baofooResponseService.updateByPrimaryKeySelective(iRequest, baofooResponse);
                responseData.setMessage(baofooResponse.getRespMsg());
                EntityUtils.consume(response.getEntity());
            }
        } finally {
            httpclient.getConnectionManager().shutdown();
        }
        return responseData;
    }


    @Override
    public ResponseData apiQuery(IRequest iRequest, Long responseId) throws Exception {
        BaofooResponse baofooResponse = new BaofooResponse();
        baofooResponse.setResponseId(responseId);
        baofooResponse = baofooResponseService.selectByPrimaryKey(iRequest, baofooResponse);
        if (baofooResponse == null) {
            throw new ResMessageException("该条扣款申请不存在");
        }
        Map<String, String> headPostParam = FormUtil.getParams(memberId, terminalId);//明文参数
        headPostParam.put("txn_sub_type", "31");//查询订单接口31
        headPostParam.put("data_content", getQueryDataContent(baofooResponse, headPostParam));//加入请求密文
        HttpClient httpclient = new DefaultHttpClient();
        ResponseData responseData = new ResponseData();
        try {
            HttpResponse response = httpclient.execute(initPost(headPostParam, payUrl));
            int code = response.getStatusLine().getStatusCode();
            if (HttpStatus.SC_OK == code) {

                String PostString = EntityUtils.toString(response.getEntity(), "utf-8");
                String cerpath = URLDecoder.decode(getClass().getClassLoader().getResource(cerPath).getPath(), "utf-8");
                PostString = RsaCodingUtil.decryptByPubCerFile(PostString, cerpath);
                if (StringUtils.isEmpty(PostString)) {
                    throw new RuntimeException("私钥文件有误");
                }
                PostString = SecurityUtil.Base64Decode(PostString);
                logger.debug("response 明文{}", PostString);

                JSONObject jsonObject = JSONObject.parseObject(PostString);
                String orderStat = jsonObject.getString("order_stat");
                String queryTransSerialNo = jsonObject.getString("trans_serial_no");
                String respCode = jsonObject.getString("resp_code");
                String respMsg = jsonObject.getString("resp_msg");
                Double succAmt = jsonObject.getDouble("succ_amt") == null ? null : DoubleUtil.div(jsonObject.getDouble("succ_amt"), 100D, 2);

                baofooResponse.setOrderStat(orderStat);
                baofooResponse.setQueryTransSerialNo(queryTransSerialNo);
                baofooResponse.setRespCode(respCode);
                baofooResponse.setRespMsg(respMsg);
                baofooResponse.setSuccAmt(succAmt);

                baofooResponseService.updateByPrimaryKey(iRequest, baofooResponse);

//                JSONObject.parseObject(PostString).toCa
//                BaofooResponse baofooResponse = ((JSONObject) JsonUtils.convert(PostString)).toJavaObject(BaofooResponse.class);
//                baofooResponseService.insertSelective(iRequest, baofooResponse);
                responseData.setMessage(baofooResponse.getRespMsg());
                EntityUtils.consume(response.getEntity());
            }
        } finally {
            httpclient.getConnectionManager().shutdown();
        }
        return responseData;
    }

    private String getQueryDataContent(BaofooResponse baofooResponse, Map<String, String> headPostParam) throws Exception {
        Map<String, String> XMLArray = new HashMap<>();
        XMLArray.put("txn_sub_type", headPostParam.get("txn_sub_type"));
        XMLArray.put("biz_type", "0000");
        XMLArray.put("terminal_id", headPostParam.get("terminal_id"));
        XMLArray.put("member_id", headPostParam.get("member_id"));
        XMLArray.put("orig_trans_id", baofooResponse.getTransId());
        XMLArray.put("trans_serial_no", "TISN" + System.currentTimeMillis());
        XMLArray.put("orig_trade_date", baofooResponse.getTradeDate());
        XMLArray.put("additional_info", "附加信息");
        XMLArray.put("req_reserved", "保留");

        String pfxpath = URLDecoder.decode(getClass().getClassLoader().getResource(pfxPath).getPath(), "utf-8");//宝付私钥
        String cerpath = URLDecoder.decode(getClass().getClassLoader().getResource(cerPath).getPath(), "utf-8");//宝付公钥

        File pfxfile = new File(pfxpath);
        File cerFile = new File(cerpath);

        if (!pfxfile.exists()) {
            throw new RuntimeException("私钥文件不存在");
        }
        if (!cerFile.exists()) {
            throw new RuntimeException("公钥文件不存在");
        }

        String XmlOrJson = getRequestString(headPostParam, XMLArray);
        logger.debug("请求参数：{}", XmlOrJson);

        String base64str = SecurityUtil.Base64Encode(XmlOrJson);
        return RsaCodingUtil.encryptByPriPfxFile(base64str, pfxpath, pfxpwd);
    }

    private String getPayDataContent(Map<String, String> headPostParam, String pay_code, String acc_no, String id_card, String id_holder, String mobile, String amount) throws Exception {
        String pfxpath = URLDecoder.decode(getClass().getClassLoader().getResource(pfxPath).getPath(), "utf-8");

//        String pfxpath = pfxPath;
        String cerpath = URLDecoder.decode(getClass().getClassLoader().getResource(cerPath).getPath(), "utf-8");//宝付公钥

        File pfxfile = new File(pfxpath);
        File cerFile = new File(cerpath);

        if (!pfxfile.exists()) {
            throw new RuntimeException("私钥文件不存在");
        }
        if (!cerFile.exists()) {
            throw new RuntimeException("公钥文件不存在");
        }

        String trade_date = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());//交易日期
        Map<String, String> XMLArray = new HashMap<String, String>();
        XMLArray.put("txn_sub_type", headPostParam.get("txn_sub_type"));
        XMLArray.put("biz_type", "0000");
        XMLArray.put("terminal_id", headPostParam.get("terminal_id"));
        XMLArray.put("member_id", headPostParam.get("member_id"));
        String txn_amt = String.valueOf(new BigDecimal(amount).multiply(BigDecimal.valueOf(100)).setScale(0));//支付金额转换成分
        XMLArray.put("pay_code", pay_code);
        XMLArray.put("pay_cm", "2");//传默认值
        XMLArray.put("id_card_type", "01");//身份证传固定值。
        XMLArray.put("acc_no", acc_no);
        XMLArray.put("id_card", id_card);
        XMLArray.put("id_holder", id_holder);
        XMLArray.put("mobile", mobile);
        XMLArray.put("valid_date", "");//信用卡有效期
        XMLArray.put("valid_no", "");//信用卡安全码
        XMLArray.put("trans_id", "TID" + System.currentTimeMillis());//商户订单号
        XMLArray.put("txn_amt", txn_amt);
        XMLArray.put("trans_serial_no", "TISN" + System.currentTimeMillis());
        XMLArray.put("trade_date", trade_date);
        XMLArray.put("additional_info", "附加信息");
        XMLArray.put("req_reserved", "保留");

//        logger.debug("加密信息：{}" + XMLArray.toString());


        String XmlOrJson = getRequestString(headPostParam, XMLArray);
        logger.debug("请求参数：" + XmlOrJson);

        String base64str = SecurityUtil.Base64Encode(XmlOrJson);
        String data_content = RsaCodingUtil.encryptByPriPfxFile(base64str, pfxpath, pfxpwd);


        return data_content;
    }

    private String getRequestString(Map<String, String> headPostParam, Map<String, String> XMLArray) throws Exception {
        String XmlOrJson;
        if (headPostParam.get("data_type").equals("xml")) {
            Map<Object, Object> ArrayToObj = new HashMap<>();
            ArrayToObj.putAll(XMLArray);
            XmlOrJson = MapToXml.Coverter(ArrayToObj, "data_content");
        } else {
            JSONObject jsonObjectFromMap = JSONObject.parseObject(JSON.toJSONString(XMLArray));
            XmlOrJson = jsonObjectFromMap.toString();
        }
        return XmlOrJson;
    }

    private HttpPost initPost(Map<String, String> headPostParam, String url) throws UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(url);
        List<NameValuePair> pairs = new ArrayList<>();

        headPostParam.forEach((k, v) -> pairs.add(new BasicNameValuePair(k, v)));
        httpPost.setEntity(new UrlEncodedFormEntity(pairs, "utf-8"));
        return httpPost;
    }
}