package leaf.plugin.word2pdf;

import com.artofsolving.jodconverter.DocumentConverter;
import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.connection.SocketOpenOfficeConnection;
import com.artofsolving.jodconverter.openoffice.converter.OpenOfficeDocumentConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;

public class doc2pdf2 {
    private static final Logger logger = LoggerFactory.getLogger(doc2pdf2.class);
    /**
     * doc转pdf（程序启动openoffice）
     *
     * @param inFilePath 输入文件
     * @param outFilePath 输出文件
     * @return
     */
    public static boolean doc2pdf2(String officePath, String inFilePath, String outFilePath) {
        boolean result = false;
        // 源文件目录
        File inputFile = new File(inFilePath);
        if (!inputFile.exists()) {
            System.out.println("源文件不存在！");
            return false;
        }

    // 输出文件目录
        File outputFile = new File(outFilePath);
        if (outputFile.exists()) {
            outputFile.delete();
        }
        // OpenOffice的安装目录
       // String OpenOffice_HOME = "C:/Program Files (x86)/OpenOffice 4";//G:/Program Files (x86)/OpenOffice
        String OpenOffice_HOME = officePath;
        if (OpenOffice_HOME.charAt(OpenOffice_HOME.length() - 1) != '/') {
            OpenOffice_HOME += "/";
        }
        Process process = null;
        try {
            logger.info("Word转PDF开始启动...");
            logger.info("Word转PDF开始启动..."+outFilePath);
            // 启动OpenOffice的服务
            String command = OpenOffice_HOME
                    + "program/soffice.exe -headless -accept=\"socket,host=127.0.0.1,port=8100;urp;\"";
          //  System.out.println(command);
            logger.info("Word转PDF开始启动...命令"+command);
            process = Runtime.getRuntime().exec(command);
            // 连接 OpenOffice实例，运行在8100端口
            OpenOfficeConnection connection = new SocketOpenOfficeConnection("127.0.0.1", 8100);
            connection.connect();
            logger.info("Word转PDF开始启动...3232323");
            // 转换
            DocumentConverter converter = new OpenOfficeDocumentConverter(connection);
            converter.convert(inputFile, outputFile);

            // 关闭连接
            connection.disconnect();
            // 销毁OpenOffice服务的进程
            process.destroy();

            logger.info("****pdf转换成功，PDF输出：" + outputFile.getPath() + "****");
            return true;
        } catch (Exception e) {
            logger.error("pdf转换失败", e);
        } finally {
            if (process != null) {
                process.destroy();
            }
        }
        return result;
    }
    public static void main(String[] args) throws Exception {

//		String jacobDllPath = "D:\\ideaProjects\\leaf-hlcm\\src\\main\\webapp\\WEB-INF\\server-script\\jacob\\jacob-1.18-x64.dll";
//		System.setProperty("jacob.dll.path", jacobDllPath);
//		System.setProperty("com.jacob.debug", "true");
        doc2pdf2("C:/Program Files (x86)/OpenOffice 4","D:\\u01\\hls_file\\excel\\1C676966F0684947A67356CDB537C45Ccon28167.docx",
				"D:\\hand-Prpjects\\融资租赁合同文本-4pdf.pdf");
//        cutPdf("D:\\\\hand-Prpjects\\\\付款请求书打印.pdf");
//		excel2pdf("D:\\work\\leafProjects\\YondaTl\\src\\test.xlsx",
//				"D:\\work\\leafProjects\\YondaTl\\src\\付款通知书NEW.pdf");
//		excel2pdfOrientation("D:\\work\\leafProjects\\YondaTl\\src\\test.xlsx",
//				"D:\\work\\leafProjects\\YondaTl\\src\\付款通知书NEW.pdf");
    }
}
