package com.hand.kinggrid;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;


import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

/**
 * 合同相关测试（使用模板）接口
 * @author Administrator
 *
 */
public class ContractWithTemplate {

    //public static final String SERVER_URL = "http://10.203.0.11:8989/tosignserver";
    /**
     * 信签服务器对接应用ID
     */
    //public static final String APP_ID = "ac4a3bd1bf6f44fa86477ac251933259";
    /**
     * 信签服务器对接应用密钥
     */
    // public static final String APP_SECURITY = "7lQ7GC1HSviWAFG6";

    public static void main(String[] args) throws IOException {
        //String contractid = "testte222211";
        String contractid = UUID.randomUUID().toString().replaceAll("-", "");//合同编号，随机生成

        JSONObject json = generateContract(contractid , null);

        //System.out.println(json);
        if(json.getInteger("code") == 1){//创建成功
            downFiles(json.getJSONArray("doc_last_urls"), "d:/"+contractid,null,null,null);
            json = signContract(contractid,null);
            json = signContract2(contractid,null);
            if(json.getInteger("code") == 1){//签署成功
                downFiles(json.getJSONArray("record_saved_urls"), "d:/"+contractid,null,null,null);
                System.out.println("record_saved_urls:"+json.getJSONArray("record_saved_urls"));
            }else{
                System.out.println(json);
            }
        }


    }

    /**
     * 下载多个文件保存在文件夹
     * @param urls
     * @param savePath
     * @throws IOException
     */
    public static final void downFiles(JSONArray urls , String savePath,String server_url,String app_id,String app_security) throws IOException{
        for (Object url : urls) {
            downFile((String)url, savePath,server_url,app_id,app_security);
        }
    }

    /**
     * 下载文件保存
     * @param url
     * @param savePath
     * @throws IOException
     */
    public static final void downFile(String url , String savePath,String server_url,String app_id,String app_security) throws IOException{
        HttpRequest request = MainRequest.createHttpRequest(url,server_url,app_id,app_security);
        //HttpRequest request = new HttpRequest(url);
        request.send();
        int code = request.getResponseCode();
        if(code==200){
            FileOutputStream fos = null;
            try{
                String fileName = savePath;
                if ((!savePath.endsWith("/")) && (!savePath.endsWith("\\"))) {
                    fileName = fileName + "/";
                }
                fileName = fileName + request.getDownFileName();
                File file = new File(fileName);

                fos = new FileOutputStream(file);

                request.result(fos);
            } finally {
                if (fos != null)
                    fos.close();
            }
        }
        else {
            System.out.println("错误信息：" + request.resultToString());
        }
    }



    /**
     * 使用模板创建合同
     * @throws IOException
     */
    public static JSONObject generateContract(String contractid , String contract_tpl_code) throws IOException{
        HttpRequest request = MainRequest.createHttpRequest("/api/contract/start",null,null,null);
        //{"姓名":"李东长","cardname_ID":"360111198708080899","year":"2018","month":"01","day":"01"}
        JSONObject docx_metadata = new JSONObject(true);
        docx_metadata.put("INSURANCE_COMPANY", "信签售后");
        docx_metadata.put("INSURANCE_MAN", "龚琪");
        docx_metadata.put("PLATE_NUM", "京A88888");
        docx_metadata.put("INSURANCE_YEAR", "2018");
        docx_metadata.put("INSURANCE_MONTH", "05");
        docx_metadata.put("INSURANCE_DAY", "21");
        docx_metadata.put("INSURANCE_MONEY", "50000");
        docx_metadata.put("SIGN_YEAR", "2018");
        docx_metadata.put("SIGN_MONTH", "05");
        docx_metadata.put("SIGN_DAY", "21");

        //quest.addFile("attach_file", new File("d:/t1.pdf"));

        //request.addFile("attach_file", new File("d:/t2.gif"));

        //request.addFile("attach_file_2", new File("d:/test.docx"));
        //request.addParam("contract_tlp_code",contract_tpl_code);
        request.addParam("contract_tlp_code","nxs001");

        request.addParam("doc_metadata",docx_metadata.toJSONString());

        //设置合同ID
        request.addParam("contract_id", contractid);
        //设置合同名称参数
        request.addParam("contract_name", "测试");

        //设置业务编码参数
        request.addParam("biz_id", UUID.randomUUID().toString().replaceAll("-", ""));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        //设置业务时间参数
        request.addParam("biz_time", sdf.format(new Date()));


        request.send();
        return JSONObject.parseObject(request.resultToString());

    }

    /**
     * 签署合同
     * @throws IOException
     */
    public static JSONObject signContract(String contractid , String signer_code ) throws IOException{
        HttpRequest request = MainRequest.createHttpRequest("/api/contract/sign",null,null,null);
        request.addParam("contract_id", contractid);
        request.addParam("biz_id", UUID.randomUUID().toString().replaceAll("-", ""));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        //设置业务时间参数
        request.addParam("biz_time", sdf.format(new Date()));
        //设置签署人的编码
        request.addParam("signer_code", signer_code);
        //设置签署位置信息
        //request.addParam("signatures", "[{ y:680,x:200,pageno:\"1\"}]");

        request.send();

        return JSONObject.parseObject(request.resultToString());

    }

    public static JSONObject signContract2(String contractid , String signer_code ) throws IOException{
        HttpRequest request = MainRequest.createHttpRequest("/api/contract/sign",null,null,null);
        request.addParam("contract_id", contractid);
        request.addParam("biz_id", UUID.randomUUID().toString().replaceAll("-", ""));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        //设置业务时间参数
        request.addParam("biz_time", sdf.format(new Date()));
        //设置签署人的编码
        request.addParam("signer_code", "xurong");
        //设置签署位置信息
        //request.addParam("signatures", "[{ y:680,x:200,pageno:\"1\"}]");

        request.send();

        return JSONObject.parseObject(request.resultToString());

    }
}

