package com.hand.hls.hlcm.ccx.service.impl;

import com.hand.hls.hlcm.ccx.service.ICcxIdentityService;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

@Service
@Transactional(rollbackFor = Exception.class)
public class CcxIdentityServiceImpl implements ICcxIdentityService {
    Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public String sendCcxIdentityMessage(String apiUrl, String account, String privateKey, String cid, String name) throws Exception{
        //创建HttpClient对象
//        CloseableHttpClient httpclient = HttpClients.createDefault();
        //DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpClient httpclient = new DefaultHttpClient();
        String ccx= null;
        try {
            //信任所有主机-对于任何证书都不做检查
            X509TrustManager tm = new X509TrustManager() {
                // 不作任何校验
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }
                // 不作任何校验
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }
                // 返回null
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            };
            // 创建SSLContext对象，并使用我们指定的信任管理器初始化
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, new TrustManager[] { tm }, null);
            // 从上述SSLContext对象中得到SSLSocketFactory对象
            SSLSocketFactory socketFactory = new SSLSocketFactory(sslcontext);
            //关闭host验证，允许和所有的host建立SSL通信
            socketFactory.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            Scheme sch = new Scheme("https", 443, socketFactory);
            httpclient.getConnectionManager().getSchemeRegistry().register(sch);
            // calculate sign
            String base = "account" + account + "cid" + cid + "name" + name + privateKey;
            //转换为md5加密并大写
            String sign = md5(base).toUpperCase();
            System.out.println("==============" + base);
            System.out.println("==============" + sign);
            //拼接URL
            String url = apiUrl + "?account=" + account + "&cid=" + cid + "&name=" + URLEncoder.encode(name, "UTF-8")
                    + "&sign=" + URLEncoder.encode(sign, "UTF-8");

            System.out.println("url: " + url);

            HttpGet httpget = new HttpGet(url);

            System.out.println("executing request" + httpget.getRequestLine());
            //执行发送请求
            HttpResponse response = httpclient.execute(httpget);


            HttpEntity entity = response.getEntity();

            System.out.println("----------------------------------------");
            System.out.println(response.getStatusLine());
            if (entity != null) {
                String str = EntityUtils.toString(entity, "utf-8");
                ccx = str;
                System.out.println("http entity string: " + str);
            }
            EntityUtils.consume(entity);
        } finally {
            //关闭请求
            httpclient.getConnectionManager().shutdown();
        }
        System.out.println("ccx: " + ccx);
        return ccx;
    }

    public final static String md5(String s) {
        // char hexDigits[] = { '0', '1', '2', '3', '4', '5', '6', '7', '8',
        // '9', 'A', 'B', 'C', 'D', 'E', 'F' };
        // update MD5 string to lower-case to adapt to UMP test
        // TODO: check lower-case or upperp-case are the MD5 standard
        char hexDigits[] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };
        try {
            byte[] btInput = s.getBytes("utf-8");
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            int j = md.length;
            char str[] = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; i++) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xf];
                str[k++] = hexDigits[byte0 & 0xf];
            }

            return new String(str);
        } catch (Exception e) {
            return null;
        }
    }
}