package com.hand.hap.generator.controllers;

import com.hand.hap.generator.service.IHapGeneratorService;
import com.hand.hap.generator.dto.GeneratorInfo;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * Created by jialong.zuo@hand-china.com on 2016/10/24.
 */
@Controller
@RequestMapping(value = "/generator")
public class HapGeneratorController extends BaseController {
    @Autowired
    IHapGeneratorService service;

    @RequestMapping(value = "/alltables", method = RequestMethod.GET)
    @ResponseBody
    public ResponseData showTables() {
        return new ResponseData(service.showTables());
    }

    @RequestMapping(value = "/alltablesandviews", method = RequestMethod.GET)
    @ResponseBody
    public ResponseData showTablesAndViews() {
        return new ResponseData(service.showTablesAndViews());
    }

    @RequestMapping(value = "/newtables")
    @ResponseBody
    public int generatorTables(GeneratorInfo generatorInfo) {
        int rs = service.generatorFile(generatorInfo);
        return rs;
    }

    @RequestMapping(value = "/generator/newBMFile")
    @ResponseBody
    public ResponseData generatorBMFile(HttpServletRequest request, @RequestBody Map map) {
        ResponseData responseData = new ResponseData(false);
        String location = (String) map.get("location");
        String tableName = (String) map.get("tableName");
        String fileName = (String) map.get("fileName");
        Boolean isTable = (Boolean) map.get("isTable");
        if (StringUtils.isEmpty(location) ||
                StringUtils.isEmpty(tableName) ||
                StringUtils.isEmpty(fileName) ||
                isTable == null) {
            responseData.setMessage("参数为空");
            return responseData;
        }
        try {
            service.generateBMDBFile(location, tableName, fileName, isTable);
        } catch (IOException e) {
            responseData.setMessage(e.getMessage());
            return responseData;
        }
        return new ResponseData();
    }

}
