package com.hand.hls.hlcm.atm.service.impl;

import com.hand.hap.system.service.impl.BaseServiceImpl;
import com.hand.hls.hlcm.util.HlsFileUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import com.hand.hls.hlcm.atm.dto.HlsFndAtmAttachment;
import com.hand.hls.hlcm.atm.service.IHlsFndAtmAttachmentService;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletResponse;

@Service
@Transactional(rollbackFor = Exception.class)
public class HlsHlsFndAtmAttachmentServiceImpl extends BaseServiceImpl<HlsFndAtmAttachment> implements IHlsFndAtmAttachmentService {

    @Override
    public void downloadAttachment(String filePath, HttpServletResponse response, String type) {
        String[] filePaths = StringUtils.split("/");
        String fileName = filePaths[filePaths.length - 1];
        HlsFileUtil.downloadFile(filePath, fileName, response, type);
    }
}