package com.hand.hls.hlcm.icbc.mapper;

import com.hand.hap.mybatis.common.Mapper;
import com.hand.hls.hlcm.icbc.dto.InterfaceRecord;
import com.hand.hls.hlcm.icbc.formbean.BankBatch;
import com.hand.hls.hlcm.icbc.formbean.BankBatchGroupResult;
import com.hand.hls.hlcm.icbc.formbean.IcbcCommandBatch;
import com.hand.hls.hlcm.icbc.formbean.IcbcConfig;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface InterfaceRecordMapper extends Mapper<InterfaceRecord> {
    IcbcConfig getIcbcConfig();

    List<IcbcCommandBatch> queryCommandBatch(Long batchId);

    List<IcbcCommandBatch> queryBatchByInterFaceId(IcbcCommandBatch batch);

    void updateBankBatchGroup(@Param("interfaceId") Long interfaceId, @Param("groupId") Long groupId);

    void updateBankBatchResult(BankBatchGroupResult result);

    void hlsCreateTransaction(BankBatchGroupResult result);

    void updateBankBatchStatus(BankBatch bankBatch);

    void updateBatchStatusWithOutDate(BankBatch bankBatch);

    List<Long> queryUnfullWrittenBatchId();

    void sendBankSms(BankBatchGroupResult result);

    List<Long> queryContractIdByGroupId(Long groupId);

    List<Long> queryBatchIdForJob();

    List<Long> queryBeforeTransaction(Long batchId);
}