/**
 * [组件]
 */
function HlsConponentBase() {

}

HlsConponentBase.prototype.settingParamMap = function () {
    var self = this, t = {};
    if (self.opt.items && self.opt.items.length > 0) {
        self.opt.items.forEach(function (o) {
            t[o.name] = {
                description: o.description,
                defaultMessage: o.defaultMessage,
                map: o.map
            };
        });
    }
    self.opt.paramMapObj = t;
};

/*
* 根据请求的是hap或者BNfes返回结果
* */
HlsConponentBase.prototype.getAjaxResult = function (results) {
    if (!results.result) {
        return result.rows;
    } else {
        if (results.result.record instanceof Array) {
            return results.result.record;
        } else {
            return new Array(results.result.record);
        }
    }
};

HlsConponentBase.prototype.cancelEventBubble = function (event) {
    if (event) {
        event.stopPropagation();
    } else {
        window.event.cancelBubble = true;
    }
};

/************************************************ 组件 END ****************************************/


/**
 * [组件-Grid列表]
 */
function HlsConponentGrid() {
    paging.call(this);
}

hlsExtend(HlsConponentGrid, paging);

$jq.extend(HlsConponentGrid.prototype, {
    settingParamMap: function () {
        var self = this, t = {};
        if (self.opt.items && self.opt.items.length > 0) {
            self.opt.items.forEach(function (o) {
                t[o.name] = {
                    description: o.description,
                    defaultMessage: o.defaultMessage,
                    map: o.map
                };
            });
        }
        self.opt.paramMapObj = t;
    },

    /**
     * _init 组件初始化
     * @param  {} opt 参数
     */
    _init: function (opt) {
        this.opt = {};
        $jq.extend(true, this.opt, opt || {});
        this._initDom();
        this._setting();
        this._render();
    },

    /**
     * _intDom 获得要操作的节点
     */
    _initDom: function () {
        var self = this;
        self.opt.$jqgridDoc = $jq(self.opt.gridSelector);
    },

    /**
     * _setting 设置参数
     */
    _setting: function () {
        var self = this;
        var colomns = this.opt.columns || [],
            feilds = [],
            feildsName = [];
        self.events = [];
        for (var j = 0, i = 0; i < colomns.length; i++) {
            if (colomns[i].template) {
                self.events[j] = {};
                /*this.events[i].editor = arr[i].editor || function(){};*/
                self.events[j].template = colomns[i].template || function () {
                };
                self.events[j].index = i;
                j++;
            }
            feilds.push(colomns[i].field || "");
            feildsName.push(colomns[i].title || "");
        }
        self.setFeilds(feilds);
        self.setFeildsName(feildsName);
        self.setDataSourse(self.opt.hlsDataSource || []);
        self.setParentDiv(self.opt.$jqgridDoc.get(0));
        self.setPageSize(self.dataSource._pageSize || self.dataSource._total);
    },

    /**
     * _render 渲染组件
     */
    _render: function () {
        this.init((this.feildsName && this.feildsName.length > 0) ? undefined : 1);
        this._formatCont();
    },
    /**
     *  _formatCont 内容样式格式化
     */
    _formatCont: function () {
        var self = this;
        var events = self.events;
        var columns = self.opt.columns;
        var datas = self.datas;
        //style标签
        var $jqheaderTd = self.opt.$jqgridDoc.find("table tr:first-child td");
        for (var j = 0; j < columns.length; j++) {
            if (columns[j].headerAttributes) {
                $jqheaderTd.eq(j).attr("style", columns[j].headerAttributes.style || "");
                if (columns[j].width) {
                    $jqheaderTd.eq(j).css({
                        "width": columns[j].width,
                        "white-space": "nowrap",
                        "text-overflow": "ellipsis",
                        "overflow": "hidden"
                    });
                }

            }
            if (columns[j].attributes) {
                for (var k = 0; k < self.span.length; k++) {
                    $jq(self.span[k][j]).attr("style", columns[j].attributes.style || "");
                    if (columns[j].width) {
                        $jq(self.span[k][j]).css({
                            "width": columns[j].width,
                            "white-space": "nowrap",
                            "text-overflow": "ellipsis",
                            "overflow": "hidden"
                        });
                    }
                }
            }

            // 当columns上存在format属性
            if (columns[j].format) {
                var format = columns[j].format.toUpperCase();
                for (var k = 0; k < self.span.length; k++) {
                    switch (format) {
                        case 'CURRENCY':
                            $jq(self.span[k][j]).html(Hls.formatCurrency(datas[k][columns[j].field])).css("text-align", "right");
                            break;
                        case 'DATE':
                            $jq(self.span[k][j]).html(Hls.formatDate(datas[k][columns[j].field]));
                            break;
                    }

                }
            }
        }

        //template函数
        for (var i = 0; i < events.length; i++) {
            self.modifyEvent(events[i].index, "template", function (rowdata, rowIndex) {
                var html = self.events[i].template(rowdata, rowIndex);
                self.modifyField(self.events[i].index, html, "template", rowIndex);
            });
        }


    }
});


/**
 * [selectCheckedItem 返回选择的行数据]
 * 使用前提是对每一行上的 dom元素加上了rowdata属性
 * @return [{rowdata}]
 */
HlsConponentGrid.prototype.selectCheckedItem = function () {
    var checkedEle = $jq("input[name='notice-checkbox']:checked");
    var rowdatas = [];
    for (var i = 0; i < checkedEle.length; i++) {
        rowdatas.push($jq("#item-body-" + i)[0].rowdata);
    }
    return rowdatas;
}


/**
 * [filterData 根据pageSize对数据进行过滤]
 * @return undefined
 */
HlsConponentGrid.prototype.filterData = function () {
    if (this.opt && this.opt.hlsDataSource && this.opt.hlsDataSource.length > this.opt.pageSize) {
        this.opt.hlsDataSource.length = this.opt.pageSize;
    }
}

/**
 * [registerLocateEvent 注册行上的点击事件，事件处理函数是this.opts.locateEvent ]
 * @return undefined
 */
HlsConponentGrid.prototype.registerLocateEvent = function (element) {
    if (!this.opt.locateEvent) return;
    var opt = this.opt;
    $jq(element).click(function (event) {
        var event = event || window.event;
        event.preventDefault();
        window[opt.locateEvent](event, element[0].rowdata);
    });
}

/************************************************ 组件-Grid列表 END ****************************************/


/**
 * [组件-Chart图]
 */
function HlsConponentChart() {

}

hlsExtend(HlsConponentChart, HlsConponentBase);


/************************************************ 组件-Chart图 END ****************************************/


/**
 * [继承函数]
 */
function hlsExtend(Child, Parent) {
    var F = function () {
    };
    F.prototype = Parent.prototype;
    Child.prototype = new F();
    Child.prototype.constructor = Child;
    Child.uber = Parent.prototype;
}






















