package com.hand.hls.hlcm.icbc.utils;

import com.hand.hls.hlcm.icbc.dto.InterfaceRecord;
import com.hand.hls.hlcm.icbc.exception.IcbcException;
import com.hand.hls.hlcm.icbc.formbean.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

/**
 * @program: hlap-dr-parent
 * @author: huangtianyang
 * @create: 2018-11-05 14:31
 **/

public class IcbcUtils {
    public static String DEV_MODE = "DEV_MODE";
    public static String PRODUCT_MODE = "PRODUCT_MODE";

    /**
     * @param config  配置信息
     * @param batches 批次信息
     * @param mode    选择模式 测试或者生产
     * @return 生成发送指令信息
     */
    public static SendCommand initSendCommand(IcbcConfig config, List<IcbcCommandBatch> batches, String mode) throws IcbcException {
        Date date = getDateByMode(mode);
        SendCommand command = new SendCommand();
        command.setBatchId(batches.get(0).getBatchId());
        command.setIcbcPub(initPub(config, date));
        command.setIcbcIn(initIn(config, batches, date, mode));

        return command;

    }

    /**
     * @param list   原数列
     * @param length 分割后的数列
     * @return 分割后的数列组成的数列
     */
    public static List<List> groupList(List list, int length) {
        List<List> groupList = new ArrayList<>();
        int toIndex = length;
        for (int i = 0; i < list.size(); i = i + length) {
            if (i + length > list.size()) {
                toIndex = list.size() - i;
            }
            List newList = list.subList(i, i + toIndex);
            groupList.add(newList);
        }
        return groupList;
    }

    /**
     * @param config  配置信息
     * @param record  提交记录
     * @param batches 未核销批次信息
     *
     * @return 查询命令
     */
    public static SendCommand initQueryCommand(IcbcConfig config, InterfaceRecord record,
                                               List<IcbcCommandBatch> batches) {
//        Date date = getDateByMode(mode);

        SendCommand sendCommand = new SendCommand();

        IcbcPub pub = new IcbcPub();
        pub.setTransCode("QPERDIS");
        pub.setCis(config.getCis());
        pub.setBankCode(config.getBankCode());
        pub.setId(config.getId());
        pub.setTranTime(record.getTranTime());
        pub.setTranDate(record.getTranDate());
        pub.setfSeqno(StringUtils.replace(UUID.randomUUID().toString(), "-", ""));
        sendCommand.setIcbcPub(pub);

        IcbcIn in = new IcbcIn();
        in.setQryfSeqno(record.getfSeqno());
        in.setQrySerialNo(record.getSerialNo());
        in.setSignTime(record.getTranDate() + record.getTranTime());

        List<IcbcRd> rds = new ArrayList<>();
        for (IcbcCommandBatch batch : batches) {
            IcbcRd rd = new IcbcRd();
            rd.setiSeqno(String.valueOf(batch.getGroupId()));
            rd.setQryiSeqno(String.valueOf(batch.getGroupId()));
            rds.add(rd);
        }
        in.setRds(rds);
        sendCommand.setBatchId(record.getBatchId());
        sendCommand.setIcbcIn(in);

        return sendCommand;
    }


    /**
     * judge group status by code
     *
     * @param code 状态code
     * @return group 状态
     */
    public static String getGroupStatusByCode(String code) {
        switch (code) {
            case "0":
            case "1":
            case "2":
            case "3":
            case "4":
            case "5":
            case "9":
            case "10":
            case "11":
            case "15":
            case "16":
            case "95":
                return BankBatchGroupResult.STATUS_DEAL;
            case "7":
                return BankBatchGroupResult.STATUS_SUCCESS;
            case "6":
            case "8":
                return BankBatchGroupResult.STATUS_FAIL;
            default:
                return null;
        }


    }

    private static Date getDateByMode(String mode) {
        Date date;
        if (DEV_MODE.equals(mode)) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(Calendar.YEAR, 2019);
            calendar.set(Calendar.MONTH, 0);
            calendar.set(Calendar.DATE, 20);
            calendar.set(Calendar.MINUTE, calendar.get(Calendar.MINUTE) - 10);
            date = calendar.getTime();
        } else {
            date = new Date();
        }
        return date;
    }

    private static IcbcPub initPub(IcbcConfig config, Date date) {
        IcbcPub pub = new IcbcPub();
        pub.setTransCode("PERDISCOL");
//        pub.setTransCode("PERDIS");
        pub.setCis(config.getCis());
        pub.setId(config.getId());
        pub.setBankCode(config.getBankCode());
        pub.setfSeqno(StringUtils.replace(UUID.randomUUID().toString(), "-", ""));
        pub.setTranDate(DateFormatUtils.getDateFormat().format(date));
        pub.setTranTime(DateFormatUtils.getTimeFormat().format(date));
        return pub;
    }

    private static IcbcIn initIn(IcbcConfig config, List<IcbcCommandBatch> batches, Date date, String mode) throws IcbcException {
        if (CollectionUtils.isEmpty(batches)) {
            throw new IcbcException("批次扣款项目为空！");
        }
        if (batches.size() > 100) {
            throw new IcbcException("单词发送不可超过100条！");
        }
        IcbcIn in = new IcbcIn();
        in.setSignTime(DateFormatUtils.getDateTimeFormat().format(date));
        in.setOnlBatF("1");
//        in.setSettleMode("0");
        in.setBusType("01");
        in.setRecAccNo(batches.get(0).getBankAccountNum());
        in.setRecAccNameCN(batches.get(0).getBankAccountName());
//        if (DEV_MODE.equals(mode)) {
//            in.setRecAccNameCN("");
//        }
        in.setTotalNum(String.valueOf(batches.size()));

        List<IcbcRd> rds = new ArrayList<>();
        Double totalAmt = 0D;
        for (IcbcCommandBatch batch : batches) {
            totalAmt = DoubleUtil.sum(totalAmt, DoubleUtil.mul(batch.getActualAmount(),100D));
            IcbcRd rd = new IcbcRd();
            rd.setiSeqno(String.valueOf(batch.getGroupId()));
            rd.setPayAccNo(batch.getEbankAccountNum());
            rd.setPayAccNameCN(batch.getEbankAccountName());
            rd.setPayBranch("中国工商银行");
            rd.setPortno(batch.getPortNumber());
            if (DEV_MODE.equals(mode)) {
                rd.setPortno("A001");
            }
            rd.setContractNo(config.getContractNo());
            rd.setCurrType("001");
            rd.setPayAmt(DoubleUtil.getString(DoubleUtil.mul(batch.getActualAmount(),100D)));
            rd.setUseCN("租金");
            rds.add(rd);
        }

        in.setTotalAmt(DoubleUtil.getString(totalAmt));
        in.setRds(rds);

        return in;

    }


}
