package com.hand.hls.hlcm.icbc.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hls.hlcm.icbc.dto.EbankWithholdBatch;
import com.hand.hls.hlcm.icbc.dto.EbankWithholdDetail;
import com.hand.hls.hlcm.icbc.dto.InterfaceRecord;
import com.hand.hls.hlcm.icbc.exception.IcbcException;
import com.hand.hls.hlcm.icbc.formbean.*;
import com.hand.hls.hlcm.icbc.mapper.EbankWithholdBatchMapper;
import com.hand.hls.hlcm.icbc.mapper.EbankWithholdDetailMapper;
import com.hand.hls.hlcm.icbc.mapper.InterfaceRecordMapper;
import com.hand.hls.hlcm.icbc.service.IEbankWithholdBatchService;
import com.hand.hls.hlcm.icbc.service.IInitCommandService;
import com.hand.hls.hlcm.icbc.service.IInterfaceRecordService;
import com.hand.hls.hlcm.icbc.utils.DoubleUtil;
import com.hand.hls.hlcm.icbc.utils.IcbcUtils;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @program: hlap-dr-parent
 * @description: ${description}
 * @author: huangtianyang
 * @create: 2018-12-20 16:45
 **/

@Service("initWithHoldCommandServiceImpl")
@Transactional(noRollbackFor = RuntimeException.class)
public class InitWithHoldCommandServiceImpl implements IInitCommandService {

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private IEbankWithholdBatchService batchService;
    @Autowired
    private InterfaceRecordMapper recordMapper;
    @Autowired
    private EbankWithholdBatchMapper batchMapper;
    @Autowired
    private EbankWithholdDetailMapper detailMapper;
    @Autowired
    @Qualifier("interfaceWithHoldRecordServiceImpl")
    private IInterfaceRecordService recordService;

    @Override
    public void initSendCommand(IRequest iRequest, Long batchId, String mode) throws Exception {

        //接口配置信息
        IcbcConfig icbcConfig = recordMapper.getIcbcConfig();
        logger.debug("###icbcConfig is {}###", icbcConfig.toString());

        //批次信息
        EbankWithholdBatch batch = new EbankWithholdBatch();
        batch.setBatchId(batchId);
        batch.setStatus("NEW");
        EbankWithholdBatch withholdBatch = batchService.selectByPrimaryKey(iRequest, batch);
        if (withholdBatch == null) {
            logger.error("invalid batchId: {}", batchId);
            throw new IcbcException("该代扣批次不存在或不可发送");
        }
        if (!"NEW".equals(withholdBatch.getStatus())) {
            logger.error("invalid batch status: {}", withholdBatch.toString());
            throw new IcbcException("该状态的批次不可发送:" + withholdBatch.getStatus());
        }

        //修改状态发送中
        withholdBatch.setBatchId(batchId);
        withholdBatch.setStatus("POST");
        batchMapper.updateBankBatchStatus(withholdBatch);

        EbankWithholdDetail detail = new EbankWithholdDetail();
        detail.setBatchId(batchId);
        detail.setStatus("NEW");
        List<IcbcCommandBatch> batches = detailMapper.queryCommandBatch(detail);

        if (CollectionUtils.isEmpty(batches)) {
            logger.error("invalid batchId {},can not find details", batchId);
            throw new IcbcException("该批次下没有需要代扣的数据");
        }
        //把detailId给groupId作为参数
        for (IcbcCommandBatch commandBatch : batches) {
            commandBatch.setGroupId(commandBatch.getDetailId());
        }

        //最多100 再多自杀
        List<List> batchGroups = IcbcUtils.groupList(batches, 80);
        for (List<IcbcCommandBatch> batchGroup : batchGroups) {
            SendCommand sendCommand = IcbcUtils.initSendCommand(icbcConfig, batchGroup, mode);
            recordService.submitOrder(iRequest, sendCommand, "submit");
        }
    }

    @Override
    @SuppressWarnings("unchecked")
    public void initQueryCommand(IRequest iRequest, Long batchId) throws Exception {
        IcbcConfig config = recordMapper.getIcbcConfig();
        logger.debug("###icbcConfig is {}###", config.toString());


        InterfaceRecord record = new InterfaceRecord();
        record.setBatchId(batchId);
        List<InterfaceRecord> records = recordMapper.select(record);

        EbankWithholdBatch bankBatch = new EbankWithholdBatch();
        bankBatch.setBatchId(batchId);
        bankBatch.setStatus("RETURN");

        for (InterfaceRecord interfaceRecord : records) {
            Long interfaceId = interfaceRecord.getInterfaceId();
            EbankWithholdDetail detail = new EbankWithholdDetail();
            detail.setBatchId(batchId);
            detail.setInterfaceId(interfaceId);

            List<IcbcCommandBatch> batches = detailMapper.queryBatchByInterFaceId(detail);
            if (CollectionUtils.isNotEmpty(batches)) {
                for (IcbcCommandBatch batch : batches) {
                    batch.setGroupId(batch.getDetailId());
                }
                SendCommand sendCommand = IcbcUtils.initQueryCommand(config, interfaceRecord, batches);

                List<IcbcRd> rds = recordService.submitOrder(iRequest, sendCommand, "query");


                if (CollectionUtils.isNotEmpty(rds)) {
                    for (IcbcRd rd : rds) {
                        BankBatchGroupResult result = new BankBatchGroupResult();
                        if ("7".equals(rd.getResult())) {
                            result.setRealAmount(DoubleUtil.div(Double.valueOf(rd.getPayAmt()), 100D, 2));
                        } else {
                            result.setRealAmount(0D);
                        }
                        result.setResCode(rd.getResult());
                        result.setResMsg(rd.getBankRem());
                        result.setGroupId(Long.valueOf(rd.getQryiSeqno()));
                        result.setStatus(IcbcUtils.getGroupStatusByCode(rd.getResult()));
                        result.setBatchId(batchId);
                        result.setInterfaceId(String.valueOf(interfaceId));

                        detailMapper.updateBankBatchResult(result);

                        if ("7".equals(rd.getResult())) {
                            List<Long> contractIds = detailMapper.queryContractIdByDetailId(result.getGroupId());
                            if (CollectionUtils.isNotEmpty(contractIds)) {
                                result.setContractId(contractIds.get(0));
                                recordMapper.sendBankSms(result);
                            }
                        }

                        if (BankBatchGroupResult.STATUS_DEAL
                                .equals(IcbcUtils.getGroupStatusByCode(rd.getResult()))) {
                            bankBatch.setStatus("POST");
                        }

                    }
                }
            }
        }

//        BankBatchGroupResult groupResult = new BankBatchGroupResult();
//        groupResult.setBatchId(batchId);
//        recordMapper.hlsCreateTransaction(groupResult);
        EbankWithholdDetail detail = new EbankWithholdDetail();
        detail.setBatchId(batchId);
        List<EbankWithholdDetail> list = detailMapper.queryDetailForWriteOff(detail);
        if (CollectionUtils.isNotEmpty(list)) {
            for (EbankWithholdDetail ebankWithholdDetail : list) {
                IcbcWriteOffManual manual = new IcbcWriteOffManual();
                manual.setDetailId(ebankWithholdDetail.getDetailId());
                manual.setBatchId(ebankWithholdDetail.getBatchId());
                detailMapper.manualWriteOff(manual);
                ebankWithholdDetail.setDealFlag(manual.getDealFlag());
                ebankWithholdDetail.setDealMsg(manual.getDealMsg());
                detailMapper.updateDetailDeal(ebankWithholdDetail);
            }
        }

        batchMapper.updateBankBatchStatus(bankBatch);


    }
}
