package com.hand.hls.hlcm.hlinteface.controllers;

import com.alibaba.fastjson.JSONObject;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hls.hlcm.hlinteface.mapper.JYCInterfaceMapper;
import leaf.database.service.DatabaseServiceFactory;
import leaf.utils.ObjectRegistryHolder;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import com.google.common.util.concurrent.RateLimiter;

import java.util.*;

import leaf.database.service.BusinessModelService;
import uncertain.composite.CompositeMap;
import java.io.IOException;
@Controller
public class JYCInterfaceController extends BaseController {

    private static final RateLimiter rateLimiter = RateLimiter.create(2.0); // 每秒允许2个请求
    private static final String IP_LIMIT="39.97.244.233,39.98.188.246";
    private static final String WJ="wj";
    private static final String BM_PATH="cont.jyc_equno_query" ;
    private static final String WJFL_FIELD="WJFL" ;
    @Autowired
    JYCInterfaceMapper jYCInterfaceMapper;
    DatabaseServiceFactory dsf = ObjectRegistryHolder.getInstanceOfType(DatabaseServiceFactory.class);
    CompositeMap context = new CompositeMap();
    public boolean checkInterfacePara(String equNo,String type,String reqClientIp,JSONObject resultjson){
        String[] ipLimit = IP_LIMIT.split(",");
        if( equNo == null || equNo.isEmpty()||type == null || type.isEmpty()||reqClientIp == null || reqClientIp.isEmpty()){
            resultjson.put("JYCResponseBody",null);
            resultjson.put("ResponseCode","02");
            resultjson.put("ResponseMsg","交易异常，入参缺少必填字段!");
            return false;
        }
        if(!type.equals(WJ)){
            resultjson.put("JYCResponseBody",null);
            resultjson.put("ResponseCode","05");
            resultjson.put("ResponseMsg","查询渠道不正确!");
            return false;
        }
        if(!Arrays.asList(ipLimit).contains(reqClientIp)){
            resultjson.put("JYCResponseBody",null);
            resultjson.put("ResponseCode","04");
            resultjson.put("ResponseMsg","客户实际IP不在自名单内!");
            return false;
        }
        return true;
    }

    @RequestMapping(value = "/wjflwar2/getEquStatus")
    @ResponseBody
    public JSONObject getEquStatus(@RequestParam(value = "equNo") String equNo,
                                        @RequestParam(value = "type") String type,
                                        @RequestParam(value = "reqClientIp") String reqClientIp,
                                        HttpServletResponse response) {
        //机易查接口
        JSONObject resultjson = new JSONObject();
        if(rateLimiter.tryAcquire()){
            try {
               boolean checkFlag= checkInterfacePara(equNo,type,reqClientIp,resultjson);
                if(checkFlag) {
                    //DatabaseServiceFactory dsf = ObjectRegistryHolder.getInstanceOfType(DatabaseServiceFactory.class);
                    //CompositeMap context = new CompositeMap();
                    CompositeMap param = new CompositeMap();
                    Boolean existsFlag = false;
                    if (equNo != null) {
                        param.put("machine_number", equNo);
                    }
                    //BusinessModelService bms = dsf.getModelService(BM_PATH, context);
                    List<Map>  result = jYCInterfaceMapper.selectJycList(equNo);
                    if (result != null) {
                        Map map = result.get(0);
                        if (!ObjectUtils.isEmpty(map)) {
                                existsFlag = true;
                                JSONObject JYCResponseBody= new JSONObject();
                                JYCResponseBody.put("equNm",map.get("EQUNM"));
                                JYCResponseBody.put("brandName",map.get("BRANDNAME"));
                                JYCResponseBody.put("equMdl",map.get("EQUMDL"));
                                JYCResponseBody.put("vinNo",map.get("VINNO"));
                                JYCResponseBody.put("machineNo",map.get("MACHINENO"));
                                JYCResponseBody.put("status",map.get("STATUS"));
                                JYCResponseBody.put("platform",WJFL_FIELD);
                                resultjson.put("JYCResponseBody",JYCResponseBody);
                                resultjson.put("ResponseCode","01");
                                resultjson.put("ResponseMsg","交易正常");
                            /*for (CompositeMap child : valueList) {3
                                existsFlag = true;
                                if (child == null) {
                                    continue;
                                }
                                Long existcont = child.getLong("existcont");
                                if (existcont > 0) {

                                }
                            }*/
                        }
                    }
                    if (!existsFlag) {
                        resultjson.put("JYCResponseBody",null);
                        resultjson.put("ResponseCode","03");
                        resultjson.put("ResponseMsg","未查到该车架号/整车编号对应信息");
                    }
                }
            }catch(Exception e){
                resultjson.put("JYCResponseBody",null);
                resultjson.put("ResponseCode","06");
                resultjson.put("ResponseMsg","接口故障!"+e.getMessage());
            }
      }else{
            resultjson.put("JYCResponseBody",null);
            resultjson.put("ResponseCode","06");
            resultjson.put("ResponseMsg","接口1秒内查询次数超出限制!");
      }
        return resultjson;
    }
}
