package com.hand.att;


import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.springframework.http.HttpHeaders;




import org.springframework.web.client.RestTemplate;



import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/**
 * description
 *
 * @author Administrator 2023/01/03 15:07
 */
public class HttpPostAttUtil {

   public static String httpPostAttImport(String postUrl, String data,String token,String tokentype){
       try {
           PostMethod postMethod = null;
           HttpClient httpClient = new HttpClient();
           postMethod = new PostMethod(postUrl) ;
           RequestEntity entity = null;
           postMethod.setRequestHeader("Content-Type", "application/json") ;
           postMethod.setRequestHeader("Authorization", tokentype+" "+token) ;
           //参数设置，需要注意的就是里边不能传NULL，要传空字符串
           entity = new StringRequestEntity(data, "application/json", "UTF-8");
           // 设置请求体信息
           postMethod.setRequestEntity(entity);


           // 执行POST方法
           int response = httpClient.executeMethod(postMethod);
           String result = postMethod.getResponseBodyAsString() ;
           return result;
       } catch (Exception e) {
           return "{\n" +
                   "  \"error\": \"interError\",\n" +
                   "  \"message\": \"请求接口失败\",\n" +
                   "  \"path\": \"/oauth/token\"\n" +
                   "}";
       }
   }







    public static String UploadFile(String url, Map<String, String> param, File file, String token, String tokentype ) throws Exception {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append( url)
                    .append("?");
            int i=1;
            Set<Map.Entry<String, String>> set = param.entrySet();
            Iterator<Map.Entry<String, String>> it = set.iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> entry = (Map.Entry<String, String>) it.next();
                if(i==1){
                    stringBuffer.append(entry.getKey()+"="+entry.getValue());
                    i++;
                }else{
                    stringBuffer.append("&"+entry.getKey()+"="+entry.getValue());
                }
            }
            String post_url = stringBuffer.toString();
            System.out.println(post_url);
            CloseableHttpClient httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(post_url);
            MultipartEntityBuilder builder=MultipartEntityBuilder.create();
            builder.addBinaryBody("file",file);
            HttpEntity httpEntity=(HttpEntity)builder.build();
            httpPost.setHeader("Authorization", tokentype+" "+token);
            httpPost.setEntity(httpEntity);//设置请求参数
            HttpResponse response = httpClient.execute(httpPost);
            HttpEntity responseEntity = response.getEntity();
            String result = EntityUtils.toString(responseEntity, java.nio.charset.Charset.forName("UTF-8"));
           return  result;
        } catch (Exception ex) {
            return ex.getMessage() ;
        }
    }



    public static void main(String[] args) throws Exception {
        //String resPonse=httpPostAttImport("http://apistage.huilianyi.com/gateway/e-archives/api/open/v1/import/document","[{\"companyCode\":\"0001\",\"particularYear\":\"2022\",\"documentTypeCode\":\"DT002002\",\"originalNumber\":\"1234567890\",\"primaryField\":\"SAP_TEST0000001\",\"isPaper\":\"true\",\"documentSource\":\"SAP\",\"attachmentList\":[{\"fileURL\":\"https://gss0.baidu.com/-vo3dSag_xI4khGko9WTAnF6hhy/zhidao/pic/item/314e251f95cad1c8ea88af74793e6709c93d51b5.jpg\",\"fileName\":\"314e251f95cad1c8ea88af74793e6709c93d51b5.jpg\",\"attachmentOID\":\"\"},{\"fileURL\":\"https://gss0.baidu.com/-vo3dSag_xI4khGko9WTAnF6hhy/zhidao/pic/item/314e251f95cad1c8ea88af74793e6709c93d51b5.jpg\",\"fileName\":\"314e251f95cad1c8ea88af74793e6709c93d51b5.jpg\",\"attachmentOID\":\"\",\"attachTypeCode\":\"0\"}],\"ruleOID\":\"684fb42f-1df4-4710-8ac7-ea0146786a05\",\"securityLevelCode\":\"CONFIDENTIAL\",\"fieldValueList\":[{\"fieldCode\":\"AMOUNT\",\"value\":\"13\"},{\"fieldCode\":\"COMPANY\",\"value\":\"阳光照明\"},{\"fieldCode\":\"DOC_NAME\",\"value\":\"日常报销单\"},{\"fieldCode\":\"CURRENCY\",\"value\":\"CNY\"},{\"fieldCode\":\"CREATED_DATE\",\"value\":\"2021-01-01 12:00:00\"},{\"fieldCode\":\"CREATION_NAME\",\"value\":\"张三\"},{\"fieldCode\":\"REMARK\",\"value\":\"去年的报销\"}]}]","4557fa35-d2da-479a-be68-323b6be619d9","Bearer");
        File file=new File("D:\\aurora_reference.pdf");
        HashMap mmp = new HashMap();
        mmp.put("documentTypeCode", "workflow_QC01");
        mmp.put("primaryField", "CF-4252CE7A665C4562BF8E8AC3AD79BF1D");
        mmp.put("documentSource", "CF");
        mmp.put("companyCode", "HL");


        //String resPonse1=doPostFile1("http://apistage.huilianyi.com/gateway/e-archives/api/open/v1/attachment/upload",mmp,file,"4557fa35-d2da-479a-be68-323b6be619d9","Bearer");
        String resPonse2=UploadFile("http://apistage.huilianyi.com/gateway/e-archives/api/open/v1/attachment/upload",mmp,file,"4557fa35-d2da-479a-be68-323b6be619d9","Bearer");
        System.out.println(resPonse2);

    }

}
