package com.hand.hlcm;


import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

/**
 * description
 *
 * @author Administrator 2023/01/03 15:07
 */
public class HttpPostUtil {

   public static String httpPostGetToken(String postUrl,String appId,String appSecret){
       /*try {
           PostMethod postMethod = null;
           postMethod = new PostMethod(postUrl) ;
           postMethod.setRequestHeader("Content-Type", "application/x-www-form-urlencoded") ;
           postMethod.setRequestHeader("Authorization", "Basic "+ Base64.getUrlEncoder().encodeToString((appId + ":" + appSecret).getBytes())) ;
           //参数设置，需要注意的就是里边不能传NULL，要传空字符串
           NameValuePair[] data = {
                   new NameValuePair("grant_type","client_credentials"),
                   new NameValuePair("scope","write")
           };
           postMethod.setRequestBody(data);
          HttpClient httpClient = new HttpClient();
           // 执行POST方法
           int response = httpClient.executeMethod(postMethod);
           String result = postMethod.getResponseBodyAsString() ;
           return result;
       } catch (Exception e) {
           return "{\n" +
                   "  \"error\": \"interError\",\n" +
                   "  \"message\": \"请求接口失败\",\n" +
                   "  \"path\": \"/oauth/token\"\n" +
                   "}";
       }*/
       HttpClient client = null;
       String result=null;
       try {
           client = new DefaultHttpClient();
           HttpPost post = new HttpPost(postUrl);
           //设置超时时间
           HttpParams params = client.getParams();
           HttpConnectionParams.setConnectionTimeout(params, (int) 10 * 1000);
           HttpConnectionParams.setSoTimeout(params, 10 * 1000);
           post.setHeader("Content-Type", "application/x-www-form-urlencoded");
           post.setHeader("Authorization", "Basic "+ Base64.getUrlEncoder().encodeToString((appId + ":" + appSecret).getBytes()));
           //post.setEntity(new StringEntity(data, "UTF-8"));
           List<BasicNameValuePair> pairs = new ArrayList<>();
           pairs.add(new BasicNameValuePair("grant_type", "client_credentials"));
           pairs.add(new BasicNameValuePair("scope", "write"));
           post.setEntity(new UrlEncodedFormEntity(pairs, "utf-8"));
           HttpResponse response =client.execute(post);
           HttpEntity entity = response.getEntity();
           result = EntityUtils.toString(entity);
           EntityUtils.consume(entity); //1. 关闭响应流
       } catch (Exception e) {
           e.printStackTrace();
       } finally {
           client.getConnectionManager().shutdown(); // 关闭连接.
           return  result;
       }
   }

    public static void main(String[] args) throws Exception {
        String resPonse=httpPostGetToken("http://apistage.huilianyi.com/gateway/oauth/token","a92074ce-ff45-409e-8ff9-3516415d8f82","NTY4ZmUyY2QtOTc3YS00MTU0LWIxNTEtYmZiNjQ5M2ZjYjY0");
        System.out.println(resPonse);
    }

}
