package com.hand.hls.hlcm.baofoo.controllers;

import com.alibaba.fastjson.JSONObject;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hls.hlcm.baofoo.dto.BaofooResponse;
import com.hand.hls.hlcm.baofoo.service.IBaofooResponseService;
import com.hand.hls.hlcm.baofoo.service.IBaofooService;
import com.hand.hls.hlcm.baofoo.utils.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

/**
 * program: hlap-dr-parent
 * description: ${DESCRIPTION}
 * author: huangtianyang
 * create: 2019-07-20 20:24
 **/
@Controller
public class BaofooController extends BaseController {
    @Autowired
    private IBaofooService baofooService;
    @Autowired
    private IBaofooResponseService baofooResponseService;

    @RequestMapping("/baofoo/pay/req")
    @ResponseBody
    public ResponseData baofooPayReq(HttpServletRequest request, @RequestBody BaofooResponse baofooResponse) {
        IRequest iRequest = createRequestContext(request);
        baofooResponse = baofooResponseService.selectByPrimaryKey(iRequest, baofooResponse);
        ResponseData responseData = new ResponseData();
        if (!"新建".equals(baofooResponse.getStatus())) {
            responseData.setMessage("只有新建的代扣可以发送指令");
            responseData.setSuccess(false);
            return responseData;
        }
        try {
            responseData = baofooService.apiPay(iRequest, baofooResponse.getPayCode(), baofooResponse.getAccNo(), baofooResponse.getIdCard(), baofooResponse.getIdHolder(), baofooResponse.getMobile(), baofooResponse.getDueAmount().toString(), baofooResponse.getResponseId());
        } catch (Exception e) {
            responseData.setSuccess(false);
            responseData.setMessage(e.getMessage());
        }
        return responseData;
    }


    @RequestMapping("/baofoo/query/req")
    @ResponseBody
    public ResponseData baofooQueryReq(HttpServletRequest request, @RequestBody BaofooResponse baofooResponse) {
        ResponseData responseData = new ResponseData();
        try {
            responseData = baofooService.apiQuery(createRequestContext(request), baofooResponse.getResponseId());
//            responseData = baofooService.apiPay(createRequestContext(request), "ICBC", "6222020111122220000", "320301198502169142", "张宝", "15261826316", "122.2");
        } catch (Exception e) {
            responseData.setSuccess(false);
            responseData.setMessage(e.getMessage());
        }
        return responseData;
    }


}
