package com.hand.hls.hlcm.icbc.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import com.hand.hls.hlcm.icbc.dto.InterfaceRecord;
import com.hand.hls.hlcm.icbc.exception.IcbcException;
import com.hand.hls.hlcm.icbc.formbean.IcbcIn;
import com.hand.hls.hlcm.icbc.formbean.IcbcPub;
import com.hand.hls.hlcm.icbc.formbean.IcbcRd;
import com.hand.hls.hlcm.icbc.formbean.SendCommand;
import com.hand.hls.hlcm.icbc.mapper.InterfaceRecordMapper;
import com.hand.hls.hlcm.icbc.service.IInterfaceRecordService;
import com.hand.hls.hlcm.icbc.utils.Base64Utils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

@Service("interfaceRecordServiceImpl")
public class InterfaceRecordServiceImpl extends BaseServiceImpl<InterfaceRecord> implements IInterfaceRecordService {


    private Logger logger = LoggerFactory.getLogger(getClass());

    private static String SIGN_SUCCESS = "0";

    @Value("${icbc.signUrl}")
    private String signUrl;

    @Value("${icbc.submitUrl}")
    private String submitUrl;

    @Autowired
    private InterfaceRecordMapper recordMapper;

    @Override
    public List submitOrder(IRequest iRequest, SendCommand command, String type) throws Exception {
        switch (type) {
            case "submit":
                postSubmit(iRequest, signOrder(iRequest, command), command);
                return null;
            case "query":
                Document document = makeQueryCommand(command);
                return postQuery(document, command);
            default:
                throw new IcbcException("invalid type: " + type);

        }


    }

    @Override
    public String signOrder(IRequest iRequest, SendCommand command) throws Exception {
        Document document = makeSubmitXml(command);
        return postSign(document);
    }

    /**
     * 请求签名数据包
     *
     * @param document dom文档
     * @return 签名后的xml信息
     */
    @SuppressWarnings("unchecked")
    public String postSign(Document document) throws IOException, DocumentException, IcbcException {
        //fixme just for test
        if (StringUtils.isEmpty(signUrl)) {
            signUrl = "http://10.40.128.126:449";
        }
        HttpClient httpclient = new DefaultHttpClient();
        try {
            HttpPost httpPost = new HttpPost(signUrl);
            httpPost.setHeader("Content-Type", "INFOSEC_SIGN/1.0");
            httpPost.setEntity(new StringEntity(stringfyDom(document), "GBK"));

            HttpResponse response = httpclient.execute(httpPost);

            int code = response.getStatusLine().getStatusCode();
            logger.debug("######HTTP STATUS {}#####", code);
            if (HttpStatus.SC_OK == code) {
                List<String> list = IOUtils.readLines(response.getEntity().getContent(), "GB2312");
                StringBuilder sb = new StringBuilder();
                for (String s : list) {
                    sb.append(s);
                }
                String xmlString = StringUtils.chomp(sb.toString());
                logger.debug(" {}", xmlString);

                Document dom = DocumentHelper.parseText(xmlString);
                List<Element> results = dom.selectNodes("//result");
                List<Element> signs = dom.selectNodes("//sign");
                if (CollectionUtils.isEmpty(signs) || CollectionUtils.isEmpty(results)) {
                    throw new IcbcException("response errors:" + xmlString);
                }
                if (!SIGN_SUCCESS.equals(results.get(0).getText())) {
                    throw new IcbcException("response result code is" + results.get(0).getText());
                }
//            response.close();
                EntityUtils.consume(response.getEntity());
                return signs.get(0).getText();
            } else {
//            response.close();
                throw new IcbcException("状态码:" + code);
            }
        } finally {
            httpclient.getConnectionManager().shutdown();
        }

    }

    public String stringfyDom(Document document) throws IOException {
        OutputFormat outputFormat = OutputFormat.createPrettyPrint();
        // 设置XML编码方式,即是用指定的编码方式保存XML文档到字符串(String),这里也可以指定为GBK或是ISO8859-1  
        outputFormat.setEncoding("GB2312");
        //            outputFormat.setSuppressDeclaration(true); //是否生产xml头
        outputFormat.setIndent(false); //设置是否缩进
//        outputFormat.setIndent("    "); //以四个空格方式实现缩进
        outputFormat.setNewlines(true); //设置是否换行


        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter(stringWriter, outputFormat);
        xmlWriter.write(document);
        xmlWriter.close();
        String xml = stringWriter.toString();
        logger.debug("This is xml for submit {}", xml);
        return xml;
    }

    public void postSubmit(IRequest iRequest, String signMessage, SendCommand sendCommand) throws IOException, IcbcException, DocumentException {

        String reqData = doPost(signMessage, sendCommand);
        logger.debug("####icbc submit reqData is #####\n{}", reqData);

        //fixme documentException
        try {
            saveSubmitReqData(iRequest, reqData, sendCommand);
        } catch (DocumentException e) {
            throw new IcbcException("Can not parse reqData :" + reqData);
        }

    }

    private List<IcbcRd> postQuery(Document document, SendCommand sendCommand) throws IOException, IcbcException, DocumentException {
        String xml = stringfyDom(document);
        logger.debug("The query xml is {}", xml);
        String reqData = doPost(xml, sendCommand);
        logger.debug("###ICBC query reqData is ####\n{} ", reqData);
        return parseQueryReqData(reqData);

    }

    /**
     * 提交post请求
     *
     * @param signMessage 签名
     * @param sendCommand 发送对象
     * @return 返回报文
     * @throws IOException
     * @throws IcbcException
     */
    private String doPost(String signMessage, SendCommand sendCommand) throws IOException, IcbcException {
        SimpleDateFormat format = new SimpleDateFormat("yyyMMddHHmmssSSS");

        HttpClient httpClient = new DefaultHttpClient();
        try {
            if (StringUtils.isEmpty(submitUrl)) {
                submitUrl = "http://10.40.128.126:458";
            }

            StringBuilder submitUri = new StringBuilder(submitUrl);
            submitUri.append("/servlet/ICBCCMPAPIReqServlet?userID=");
            submitUri.append(sendCommand.getIcbcPub().getId());
            submitUri.append("&PackageID=");
            submitUri.append(sendCommand.getIcbcPub().getfSeqno());
            submitUri.append("&SendTime=");
            submitUri.append(sendCommand.getIcbcIn().getSignTime());

            logger.debug(submitUri.toString());

            HttpPost httpPost = new HttpPost(submitUri.toString());
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
            httpPost.setHeader("charset", "GB2312");

            httpPost.setEntity(new UrlEncodedFormEntity(initNameValuePairs(sendCommand, signMessage), "GB2312"));

            HttpResponse httpResponse = httpClient.execute(httpPost);

            int code = httpResponse.getStatusLine().getStatusCode();
            logger.debug("#### status code is {} $$$$", code);
            if (HttpStatus.SC_OK != code) {
//            httpResponse.close();
                throw new IcbcException("状态码：" + code);
            }
            List<String> list = IOUtils.readLines(httpResponse.getEntity().getContent(), "GB2312");
            StringBuilder sb = new StringBuilder();
            for (String s : list) {
                sb.append(s + System.getProperty("line.separator"));
            }

            String result = sb.toString();
//        httpResponse.close();
            EntityUtils.consume(httpResponse.getEntity());
            logger.debug(result);
            String[] strings = StringUtils.split(result, "=");
            if ("errorCode".equals(strings[0])) {
                throw new IcbcException("errorCode=" + strings[1]);
            }
            return Base64Utils.decode(StringUtils.chomp(StringUtils.substring(result, 8)));
        } finally {
            httpClient.getConnectionManager().shutdown();
        }
    }


    /**
     * 解析并保存报文
     *
     * @param reqData 返回报文
     * @throws DocumentException
     * @throws IcbcException
     */
    @SuppressWarnings("unchecked")
    public void saveSubmitReqData(IRequest iRequest, String reqData, SendCommand sendCommand) throws DocumentException, IcbcException {
        Document document = DocumentHelper.parseText(StringUtils.trim(reqData));
        List<Element> retCodes = document.selectNodes("//pub/RetCode");
        List<Element> retMsgs = document.selectNodes("//pub/RetMsg");
        List<Element> tranDates = document.selectNodes("//pub/TranDate");
        List<Element> tranTimes = document.selectNodes("//pub/TranTime");
        List<Element> fSeqnos = document.selectNodes("//pub/fSeqno");
        List<Element> serialNos = document.selectNodes("//pub/SerialNo");

        if (CollectionUtils.isEmpty(retCodes) ||
                CollectionUtils.isEmpty(retMsgs)) {
            throw new IcbcException("invalid response: " + reqData);
        }
        if (SIGN_SUCCESS.equals(retCodes.get(0).getTextTrim())) {
            logger.debug("CODE: {}", retCodes.get(0).getTextTrim());
            logger.debug("MESSAGE: {}", retMsgs.get(0).getTextTrim());
            //保存开始 0_0
            InterfaceRecord interfaceRecord = new InterfaceRecord();
            interfaceRecord.setTranDate(getText(tranDates));
            interfaceRecord.setTranTime(getText(tranTimes));
            interfaceRecord.setfSeqno(getText(fSeqnos));
            interfaceRecord.setSerialNo(getText(serialNos));
            interfaceRecord.setBatchId(sendCommand.getBatchId());
            InterfaceRecord result = self().insertSelective(iRequest, interfaceRecord);

            List<IcbcRd> rds = sendCommand.getIcbcIn().getRds();
            if (CollectionUtils.isNotEmpty(rds)) {
                Long interfaceId = result.getInterfaceId();
                for (IcbcRd rd : rds) {
                    Long groupId = Long.valueOf(rd.getiSeqno());
                    recordMapper.updateBankBatchGroup(interfaceId, groupId);
                }
            }

        } else {
            throw new IcbcException("submit failed: CODE:" + retCodes.get(0).getTextTrim() +
                    ";MESSAGE:" + retMsgs.get(0).getTextTrim());
        }
    }

    @SuppressWarnings("unchecked")
    private List<IcbcRd> parseQueryReqData(String reqData) throws DocumentException, IcbcException {
        Document document = DocumentHelper.parseText(StringUtils.trim(reqData));
        List<Element> retCodes = document.selectNodes("//RetCode");
        List<Element> retMsgs = document.selectNodes("//RetMsg");
        List<Element> rds = document.selectNodes("//rd");

        if (CollectionUtils.isEmpty(retCodes) ||
                CollectionUtils.isEmpty(retMsgs)) {
            throw new IcbcException("invalid response: " + reqData);
        }
        String code = retCodes.get(0).getTextTrim();
        String message = retMsgs.get(0).getTextTrim();
        if (SIGN_SUCCESS.equals(code)) {
            logger.debug("CODE: {}", code);
            logger.debug("MESSAGE: {}", message);

            List<IcbcRd> list = new ArrayList<>();

            if (CollectionUtils.isNotEmpty(rds)) {
                for (Element rd : rds) {
                    IcbcRd icbcRd = new IcbcRd();
                    icbcRd.setQryiSeqno(getText(rd.selectNodes("QryiSeqno")));
                    icbcRd.setResult(getText(rd.selectNodes("Result")));
                    icbcRd.setBankRem(getText(rd.selectNodes("BankRem")));
                    icbcRd.setiRetCode(getText(rd.selectNodes("iRetCode")));
                    icbcRd.setiRetMsg(getText(rd.selectNodes("iRetMsg")));
                    icbcRd.setPayAmt(getText(rd.selectNodes("PayAmt")));
                    list.add(icbcRd);
                }
            }
            return list;

        } else {
            throw new IcbcException("submit failed:CODE:" + code + ";MESSAGE" + message);
        }
    }


    public String getText(List<Element> elements) {
        if (CollectionUtils.isNotEmpty(elements)) {
            return elements.get(0).getText();
        }
        return null;
    }

    /**
     * 生成批量个人扣款xml文档
     *
     * @param command request参数
     * @return dom文档
     */
    public Document makeSubmitXml(SendCommand command) throws Exception {
        Document document = DocumentHelper.createDocument();
        document.setXMLEncoding("GB2312");

        Element eb = document.addElement("CMS").addElement("eb");
        Element pub = eb.addElement("pub");
        initPub(pub, command.getIcbcPub());


        Element in = eb.addElement("in");
        IcbcIn icbcIn = command.getIcbcIn();

        textElement(icbcIn, in, "OnlBatF");
//        textElement(icbcIn, in, "SettleMode");
        textElement(icbcIn, in, "BusType");
        textElement(icbcIn, in, "RecAccNo");
        textElement(icbcIn, in, "RecAccNameCN");
        textElement(icbcIn, in, "RecAccNameEN");
        textElement(icbcIn, in, "TotalNum");
        textElement(icbcIn, in, "TotalAmt");
        textElement(icbcIn, in, "SignTime");
        textElement(icbcIn, in, "ReqReserved1");
        textElement(icbcIn, in, "ReqReserved2");

        if (CollectionUtils.isEmpty(icbcIn.getRds())) {
            throw new IcbcException("Element rd is empty.");
        }
        for (IcbcRd icbcRd : icbcIn.getRds()) {
            initIn(in.addElement("rd"), icbcRd);
        }

        return document;
    }


    /**
     * 生成查询个人xml文档
     *
     * @param command command
     * @return XML文档
     * @throws Exception
     */
    public Document makeQueryCommand(SendCommand command) throws Exception {
        Document document = DocumentHelper.createDocument();
        document.setXMLEncoding("GB2312");
        Element eb = document.addElement("CMS").addElement("eb");
        Element pub = eb.addElement("pub");
        IcbcPub icbcPub = command.getIcbcPub();
        textElement(icbcPub, pub, "TransCode");
        textElement(icbcPub, pub, "CIS");
        textElement(icbcPub, pub, "BankCode");
        textElement(icbcPub, pub, "ID");
        textElement(icbcPub, pub, "TranDate");
        textElement(icbcPub, pub, "TranTime");
        textElement(icbcPub, pub, "fSeqno");

        Element in = eb.addElement("in");
        IcbcIn icbcIn = command.getIcbcIn();
        textElement(icbcIn, in, "QryfSeqno");
        textElement(icbcIn, in, "QrySerialNo");
        textElement(icbcIn, in, "ReqReserved1");
        textElement(icbcIn, in, "ReqReserved2");

        List<IcbcRd> icbcRds = icbcIn.getRds();
        for (IcbcRd icbcRd : icbcRds) {
            Element rd = in.addElement("rd");
            textElement(icbcRd, rd, "iSeqno");
            textElement(icbcRd, rd, "QryiSeqno");
            textElement(icbcRd, rd, "QryOrderNo");
            textElement(icbcRd, rd, "ReqReserved3");
            textElement(icbcRd, rd, "ReqReserved4");
        }

        return document;
    }


    private void initPub(Element element, IcbcPub pub) throws Exception {
        textElement(pub, element, "TransCode");
        textElement(pub, element, "CIS");
        textElement(pub, element, "BankCode");
        textElement(pub, element, "ID");
        textElement(pub, element, "TranDate");
        textElement(pub, element, "TranTime");
        textElement(pub, element, "fSeqno");
    }

    @SuppressWarnings("unchecked")
    private Element textElement(Object object, Element element, String name) throws Exception {
        if (object == null) {
            throw new IcbcException(name + "'s parent node is null");
        }
        if (StringUtils.isEmpty(name)) {
            throw new IcbcException("Invalid parameter " + name);
        }
        String methodName;
        switch (name) {
            case "ID":
                methodName = "getId";
                break;
            default:
                methodName = "get" + name;
        }
        logger.debug("current name is " + name);
        Class clazz = object.getClass();
        Method method = clazz.getMethod(methodName);
        String text = method.invoke(object) != null ? method.invoke(object).toString() : null;
        Element child = element.addElement(name);
        if (StringUtils.isEmpty(text)) {
//            logger.debug(name + "text is empty");
            return null;
        } else {
            child.addText(text);
            return child;
        }
    }

    private void initIn(Element element, IcbcRd icbcRd) throws Exception {
        textElement(icbcRd, element, "iSeqno");
        textElement(icbcRd, element, "PayAccNo");
        textElement(icbcRd, element, "PayAccNameCN");
        textElement(icbcRd, element, "PayAccNameEN");
        textElement(icbcRd, element, "PayBranch");
        textElement(icbcRd, element, "Portno");
        textElement(icbcRd, element, "ContractNo");
        textElement(icbcRd, element, "CurrType");
        textElement(icbcRd, element, "PayAmt");
        textElement(icbcRd, element, "UseCode");
        textElement(icbcRd, element, "UseCN");
        textElement(icbcRd, element, "EnSummary");
        textElement(icbcRd, element, "PostScript");
        textElement(icbcRd, element, "Summary");
        textElement(icbcRd, element, "Ref");
        textElement(icbcRd, element, "Oref");
        textElement(icbcRd, element, "ERPSqn");
        textElement(icbcRd, element, "BusCode");
        textElement(icbcRd, element, "ERPcheckno");
        textElement(icbcRd, element, "CrvouhType");
        textElement(icbcRd, element, "CrvouhName");
        textElement(icbcRd, element, "CrvouhNo");
        textElement(icbcRd, element, "ReqReserved3");
        textElement(icbcRd, element, "ReqReserved4");


    }


    private List<NameValuePair> initNameValuePairs(SendCommand sendCommand, String signMessage) {
        List<NameValuePair> list = new ArrayList<>();
        list.add(new BasicNameValuePair("Version", "0.0.0.1"));
        list.add(new BasicNameValuePair("TransCode", sendCommand.getIcbcPub().getTransCode()));
        list.add(new BasicNameValuePair("BankCode", sendCommand.getIcbcPub().getBankCode()));
        list.add(new BasicNameValuePair("GroupCIS", sendCommand.getIcbcPub().getCIS()));
        list.add(new BasicNameValuePair("ID", sendCommand.getIcbcPub().getId()));
        list.add(new BasicNameValuePair("PackageID", sendCommand.getIcbcPub().getfSeqno()));
        list.add(new BasicNameValuePair("Cert", null));
        list.add(new BasicNameValuePair("reqData", signMessage));

        return list;
    }
}