﻿create or replace package prj_project_check_pkg is

  -- Author  : LIJINGJING
  -- Created : 2019/9/19 18:32:46
  -- Purpose : 
  procedure check_prj_record(p_project_id        number,
                             p_payment_deduction in out varchar2,
                             p_secondary_lease   in out varchar2,
                             p_price_list        in out varchar2);
 procedure check_prj_lease_item(p_machine_number varchar2,
                                 p_user_id        number);

end prj_project_check_pkg;
/
create or replace package body prj_project_check_pkg is

  procedure check_prj_record(p_project_id        number,
                             p_payment_deduction in out varchar2,
                             p_secondary_lease   in out varchar2,
                             p_price_list        in out varchar2) is
  begin
    select p.payment_deduction,
           p.secondary_lease,
           (select pq.price_list
              from prj_quotation pq
             where pq.document_id = p.project_id
               and pq.document_category = 'PROJECT')
      into p_payment_deduction, p_secondary_lease, p_price_list
      from prj_project p
     where p.project_id = p_project_id;
  end;
  procedure check_prj_lease_item(p_machine_number varchar2,
                                 p_user_id        number) is
    v_count number;
    e_count_err exception;
  begin
    select count(*)
      into v_count
      from prj_project_lease_item t
     where t.machine_number = p_machine_number;
    if v_count > 0 then
      raise e_count_err;
    end if;
  exception
    when e_count_err then
      sys_raise_app_error_pkg.raise_sys_others_error(p_message => '该机号已存在，请重新确认！',
                                                     
                                                     p_created_by              => p_user_id,
                                                     p_package_name            => 'prj_project_check_pkg',
                                                     p_procedure_function_name => 'check_prj_lease_item');
      raise_application_error(sys_raise_app_error_pkg.c_error_number,
                              sys_raise_app_error_pkg.g_err_line_id);
  end;
end prj_project_check_pkg;
/
