package com.hand.hls.hlcm.hlinteface.controllers;

import com.alibaba.fastjson.JSONObject;
import com.hand.hap.system.controllers.BaseController;
import leaf.database.service.DatabaseServiceFactory;
import leaf.utils.ObjectRegistryHolder;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import com.google.common.util.concurrent.RateLimiter;
import java.util.List;
import leaf.database.service.BusinessModelService;
import uncertain.composite.CompositeMap;
import java.io.IOException;
@Controller
public class JYCInterfaceController extends BaseController {

    private static final RateLimiter rateLimiter = RateLimiter.create(1.0); // 每秒允许1个请求

    @RequestMapping(value = "/wjflwar2/getEquStatus")
    @ResponseBody
    public JSONObject getEquStatus(@RequestParam(value = "equNo",required = true) String equNo,
                                        @RequestParam(value = "type",required = true) String type,
                                        @RequestParam(value = "reqClientIp",required = true) String reqClientIp,
                                        HttpServletResponse response) {
        //机易查接口
        JSONObject resultjson = new JSONObject();
        if(rateLimiter.tryAcquire()){
            try {
                DatabaseServiceFactory dsf = ObjectRegistryHolder.getInstanceOfType(DatabaseServiceFactory.class);
                String queryBm = "cont.jyc_equno_query";
                CompositeMap context = new CompositeMap();
                CompositeMap param =  new CompositeMap();
                Boolean existsFlag = false;
                if (equNo != null) {
                    param.put("machine_number", equNo);
                }
                BusinessModelService bms = dsf.getModelService(queryBm, context);
                CompositeMap result = bms.queryAsMap(param);
                if (result != null) {
                    List<CompositeMap> valueList = result.getChilds();
                    if (valueList != null) {
                        for (CompositeMap child : valueList) {
                            if (child == null) {
                                continue;
                            }
                            Long existcont = child.getLong("existcont");
                            if (existcont > 0) {
                                existsFlag = true;
                            }
                        }
                    }
                }
                if (existsFlag) {
                    resultjson.put("message", "查得");
                } else {
                    resultjson.put("message", "未查得");
                }
            }catch(Exception e){
                    resultjson.put("message", "接口故障");
            }
      }else{
            resultjson.put("message","接口次数超出限制");
      }
        return resultjson;
    }
}
