package com.hand.hls.hlcm.importexcel.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hls.hlcm.importexcel.mapper.ImportExcelMapper;
import com.hand.hls.hlcm.importexcel.service.ImportExcelService;
import leaf.plugin.dataimport.ImportExcel;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * Copyright (C) Hand Business Consulting Services
 * AllRights Reserved
 *
 * @Author: administrator
 * @Date: 2021/4/29 13:24
 * @Description:
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class ImportExcelServiceImpl implements ImportExcelService {
    public static final int TOTAL_CELL = 7;

    FormulaEvaluator evaluator;
    /**
     * //public static final String XLS_KEY = ".xls";
     * // public static final String XLSX_KEY = ".xlsx";
     * //public static final String CSV_KEY = ".csv";
     * //public static final String TXT_KEY = ".txt";
     */
    DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    ImportExcelMapper importExcelMapper;

    @Override
    public ResponseData importExcel(IRequest iRequest, MultipartFile file) throws Exception {
        ResponseData responseData = new ResponseData();
        String fileName;
        fileName = file.getOriginalFilename();
        logger.info(fileName);
        String suffix = fileName.substring(fileName.lastIndexOf("."));
        Workbook wb = null;
        if (ImportExcel.XLS_KEY.equalsIgnoreCase(suffix)) {
            wb = new HSSFWorkbook(file.getInputStream());
        } else if (ImportExcel.XLSX_KEY.equalsIgnoreCase(suffix)) {
            wb = new XSSFWorkbook(file.getInputStream());
        }
        if (wb != null) {
            evaluator = wb.getCreationHelper().createFormulaEvaluator();
        }
        Sheet sheet = null;
        Row row;
        Cell cell;
        if (wb != null && wb.getNumberOfSheets() > 1) {
            responseData.setSuccess(false);
            responseData.setMessage("sheet页数大于1，请检查模板!");
            return responseData;
        }
        if (wb != null) {
            sheet = wb.getSheetAt(0);
        }
        assert sheet != null;
        int checkRow = sheet.getRow(0).getPhysicalNumberOfCells();
        if (checkRow != TOTAL_CELL) {
            responseData.setSuccess(false);
            responseData.setMessage("模板列数不匹配，请检查模板!");
            return responseData;
        }
        //获取头id
        Long headId = importExcelMapper.getHeadId();
        Map<String, Object> headMap = new HashMap<>(16);
        headMap.put("headId", headId);
        headMap.put("templateCode",iRequest.getAttribute("template_code"));
        headMap.put("jobId", null);
        headMap.put("status", "NEW");
        headMap.put("userId", iRequest.getUserId());
        headMap.put("attribute_5", "N");
        headMap.put("file_name", fileName);
        importExcelMapper.insertInterfaceHead(headMap);
        //获取行
        for (int i = 0; i <= sheet.getLastRowNum(); i++) {
            Map<String, List<Object>> fieldValues = new HashMap<>(16);
            List<Object> fields = new ArrayList<>();
            List<Object> values = new ArrayList<>();
            fields.add("HEADER_ID");
            fields.add("LINE_NUMBER");
            fields.add("CREATED_BY");
            fields.add("CREATION_DATE");
            fields.add("LAST_UPDATED_BY");
            fields.add("LAST_UPDATE_DATE");
            values.add(headId);
            values.add(i);
            values.add(iRequest.getUserId());
            values.add(new Date());
            values.add(iRequest.getUserId());
            values.add(new Date());
            row = sheet.getRow(i);
            for (int j = 0; j < row.getLastCellNum(); j++) {
                //获取列
                cell = row.getCell(j);
                fields.add("ATTRIBUTE_" + (j + 1));
                String value;
                if (cell != null) {
                    value = resetValue(cell);
                    values.add(value);
                }
            }
            fieldValues.put("columns", fields);
            fieldValues.put("values", values);
            importExcelMapper.insertInterfaceLine(fieldValues);
        }
        Map<String, Object> journalMap = new HashMap<>(16);
        journalMap.put("headId", headId);
        journalMap.put("userId", iRequest.getUserId());
        importExcelMapper.updateJournalData(journalMap);
        responseData.setSuccess(true);
        return responseData;
    }

    public String resetValue(Cell cell) {
        CellValue cellValue = evaluator.evaluate(cell);
        String value = null;
        if (cellValue != null) {
            switch (cellValue.getCellTypeEnum()) {
                case BOOLEAN:
                    value = Boolean.toString(cellValue
                            .getBooleanValue());
                    break;
                case NUMERIC:
                    if (DateUtil.isCellDateFormatted(cell)) {
                        if (cell.getDateCellValue() != null) {
                            value = df.format(cell.getDateCellValue());
                        }
                    } else {
                        value = BigDecimal
                                .valueOf(cellValue.getNumberValue())
                                .stripTrailingZeros().toPlainString();
                    }
                    break;
                case STRING:
                    value = cellValue.getStringValue();
                    break;
                case BLANK:
                case ERROR:
                case FORMULA:
                    break;
                default:
            }
        }
        if (value != null && !"".equalsIgnoreCase(value)) {
            return value;
        } else {
            return "";
        }
    }
}


