﻿create or replace function F_DAYS2STR(P_DAYS in number default 0)
  return varchar2 is
  --将天数转换成天时分秒格式
  V_DAYS number := NVL(P_DAYS, 0);
  V_D    number; --天
  V_H    number; --小时
  V_M    number; --分
  V_S    number; --秒
  result varchar2(200);
begin
  V_D := TRUNC(V_DAYS);
  V_H := TRUNC((V_DAYS - V_D) * 24);
  V_M := TRUNC((V_DAYS - V_D - V_H / 24) * 24 * 60);
  V_S := TRUNC((V_DAYS - V_D - V_H / 24 - V_M / 24 / 60) * 24 * 60 * 60);
  select DECODE(V_D, 0, '', V_D || '天') || DECODE(V_H, 0, '', V_H || '小时') ||
         DECODE(V_M, 0, '', V_M || '分') || DECODE(V_S, 0, '', V_S || '秒')
    into result
    from DUAL;
  return(result);
end;
/
