package com.hand.hls.hlcm.contact.service.impl;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.service.impl.BaseServiceImpl;
import com.hand.hls.hlcm.contact.dto.BusinessContact;
import com.hand.hls.hlcm.contact.exception.ContactException;
import com.hand.hls.hlcm.contact.mapper.BusinessContactMapper;
import com.hand.hls.hlcm.contact.service.IBusinessContactService;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
@Transactional(rollbackFor = Exception.class)
public class BusinessContactServiceImpl extends BaseServiceImpl<BusinessContact> implements IBusinessContactService {

    @Autowired
    BusinessContactMapper businessContactMapper;

    private static String BIZ_CONTACT_STATUS_CONFIRM = "CONFIRM";
    private static String BIZ_CONTACT_STATUS_SEND = "SEND";
    private static String BIZ_CONTACT_STATUS_REJECT = "REJECT";

    private Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public BusinessContact sendNotice(IRequest iRequest, BusinessContact businessContact) throws ContactException {
        if (businessContact.getBusinessId() == null) {
            logger.error("invalid parameter {}", businessContact.toString());
            throw new ContactException("尚未保存");
        }
        businessContact.setBusinessStatus(BIZ_CONTACT_STATUS_SEND);
        self().updateByPrimaryKeySelective(iRequest, businessContact);
        //收件人
        String[] recs = StringUtils.split(businessContact.getBusinessRecs(), ";");
        businessNotice(iRequest, businessContact, recs);

        //抄送
        String[] ccs = StringUtils.split(businessContact.getBusinessCcs(), ";");
        businessNotice(iRequest, businessContact, ccs);
        return businessContact;
    }

    @Override
    public void approveNotice(IRequest iRequest, BusinessContact businessContact) {
        businessContact.setBusinessConfirmUser(iRequest.getUserId());
        businessContact.setBusinessConfirmDate(new Date());
        List<Long> noticeMsgIds = businessContactMapper.selectNoticeMsgIdBySourceId(businessContact.getBusinessId());
        for (Long noticeMsgId : noticeMsgIds) {
            Map<String, Object> map = new HashMap<>();
            map.put("notice_msg_id", noticeMsgId);
            map.put("user_id", iRequest.getUserId());
            businessContactMapper.closeNotice(map);
        }
        self().updateByPrimaryKeySelective(iRequest, businessContact);
    }

    @Override
    public BusinessContact saveContact(IRequest iRequest, BusinessContact businessContact) {
        BusinessContact result;
        if (businessContact.getBusinessId() != null) {
            result = self().updateByPrimaryKeySelective(iRequest, businessContact);
        } else {
            businessContact.setBusinessContactNumber(businessContactMapper.selectMaxNum());
            result = self().insertSelective(iRequest, businessContact);
        }
        return result;
    }

    /**
     * 发送联络函
     *
     * @param businessContact 通信联络函
     * @param users           收件人数组
     */
    private void businessNotice(IRequest iRequest, BusinessContact businessContact, String[] users) {
        if (ArrayUtils.isNotEmpty(users)) {
            for (String user : users) {
                if (StringUtils.isNotEmpty(user)) {
                    Map<String, Object> map = new HashMap<>();
                    map.put("notice_user_id", user);
                    map.put("msg_title", businessContact.getBusinessContactNumber() +
                            "--" + businessContact.getBusinessSubject());
                    map.put("msg_body", businessContact.getBusinessText());
                    map.put("user_id", iRequest.getUserId());
                    map.put("source_id", businessContact.getBusinessId());
                    map.put("notice_url", "contact/business_contact_send.lview");
                    businessContactMapper.notice(map);
                }
            }
        }
    }


}