package com.hand.hls.hlcm.sys.controllers;

import org.springframework.stereotype.Controller;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hls.hlcm.sys.dto.SysNoticeMsgDoosan;
import com.hand.hls.hlcm.sys.service.ISysNoticeMsgDoosanService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

import org.springframework.validation.BindingResult;

import java.util.List;

@Controller
public class SysNoticeMsgDoosanController extends BaseController {

    @Autowired
    private ISysNoticeMsgDoosanService service;


    @RequestMapping(value = "/sys/notice/msg/notice")
    @ResponseBody
    public ResponseData insertNotice(HttpServletRequest request, @RequestBody List<SysNoticeMsgDoosan> noticeMsgs) {
        IRequest iRequest = createRequestContext(request);
        for (SysNoticeMsgDoosan noticeMsg:noticeMsgs) {
            service.insertNotice(iRequest, noticeMsg);
        }
        return new ResponseData();
    }
}