package com.hand.hls.hlcm.importexcel.controllers;

import com.hand.hap.core.IRequest;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hls.hlcm.importexcel.service.ImportExcelService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * Copyright (C) Hand Business Consulting Services
 * AllRights Reserved
 *
 * @Author: administrator
 * @Date: 2021/4/29 11:11
 * @Description:建机模板导入二开
 */
@Controller
public class ImportExcelController extends BaseController {
    @Autowired
    ImportExcelService importExcelService;

    @RequestMapping(value = "/hls/importExcel/import")
    @ResponseBody
    public ResponseData importExcel(@RequestParam Map <String,String> map,@RequestParam(value = "content",required = false) MultipartFile importFile, HttpServletRequest request) throws Exception{
        ResponseData responseData = new ResponseData();
        String template_code=request.getParameter("template_code");
        Assert.notNull(template_code,"templateCode为空");
        IRequest requestContext = createRequestContext(request);
        requestContext.setAttribute("template_code",template_code);
        responseData=importExcelService.importExcel(requestContext,importFile);
        return responseData;

    }
}
