package com.hand.hls.hlcm.contact.controllers;

import com.hand.hls.hlcm.contact.exception.ContactException;
import org.springframework.stereotype.Controller;
import com.hand.hap.system.controllers.BaseController;
import com.hand.hap.core.IRequest;
import com.hand.hap.system.dto.ResponseData;
import com.hand.hls.hlcm.contact.dto.BusinessContact;
import com.hand.hls.hlcm.contact.service.IBusinessContactService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

import org.springframework.validation.BindingResult;

import java.util.ArrayList;
import java.util.List;

@Controller
public class BusinessContactController extends BaseController {

    @Autowired
    private IBusinessContactService service;


    @RequestMapping(value = "/business/contacts/query")
    @ResponseBody
    public ResponseData query(BusinessContact dto, @RequestParam(defaultValue = DEFAULT_PAGE) int page,
                              @RequestParam(defaultValue = DEFAULT_PAGE_SIZE) int pageSize, HttpServletRequest request) {
        IRequest requestContext = createRequestContext(request);
        return new ResponseData(service.select(requestContext, dto, page, pageSize));
    }


    @RequestMapping(value = "/business/contacts/submit")
    @ResponseBody
    public ResponseData update(@RequestBody List<BusinessContact> dto, BindingResult result, HttpServletRequest request) {
        getValidator().validate(dto, result);
        if (result.hasErrors()) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(getErrorMessage(result, request));
            return responseData;
        }
        IRequest requestCtx = createRequestContext(request);
        return new ResponseData(service.batchUpdate(requestCtx, dto));
    }

    @RequestMapping(value = "/business/contacts/remove")
    @ResponseBody
    public ResponseData delete(HttpServletRequest request, @RequestBody List<BusinessContact> dto) {
        service.batchDelete(dto);
        return new ResponseData();
    }

    @RequestMapping(value = "/business/contacts/sendnotice")
    @ResponseBody
    public ResponseData notice(HttpServletRequest request, @RequestBody BusinessContact businessContact) {
        IRequest iRequest = createRequestContext(request);
        List<BusinessContact> list = new ArrayList();
        try {
            list.add(service.sendNotice(iRequest, businessContact));
        } catch (ContactException e) {
            ResponseData responseData = new ResponseData(false);
            responseData.setMessage(e.getMessage());
        }
        return new ResponseData(list);
    }

    @RequestMapping(value = "/business/contacts/approvenotice")
    @ResponseBody
    public ResponseData approveNotice(HttpServletRequest request, @RequestBody BusinessContact businessContact) {
        IRequest iRequest = createRequestContext(request);
        service.approveNotice(iRequest, businessContact);
        return new ResponseData();
    }

    @RequestMapping(value = "/business/contacts/savecontact")
    @ResponseBody
    public ResponseData saveContact(HttpServletRequest request, @RequestBody BusinessContact businessContact) {
        IRequest iRequest = createRequestContext(request);
        List<BusinessContact> businessContacts = new ArrayList<>();
        businessContacts.add(service.saveContact(iRequest, businessContact));
        return new ResponseData(businessContacts);
    }

}