
package com.hand.hlcm;


import com.alibaba.fastjson.JSON;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpPostDocQuery {
    public HttpPostDocQuery() {
    }
    public static String httpPostDocImport(String postUrl, String data, String token, String tokentype) {
        HttpClient client = null;
        String result = "error";
        try {
            client = new DefaultHttpClient();
            HttpPost post = new HttpPost(postUrl);
            //设置超时时间
            HttpParams params = client.getParams();
            HttpConnectionParams.setConnectionTimeout(params, (int) 10 * 1000);
            HttpConnectionParams.setSoTimeout(params, 10 * 1000);
            post.setHeader("Content-Type", "application/json");
            post.setHeader("Authorization", tokentype + " " + token);
            post.setEntity(new StringEntity(data, "UTF-8"));
            HttpResponse response = null;
            response = client.execute(post);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString(entity, "UTF-8");
            EntityUtils.consume(entity); //1. 关闭响应流
            if (entity != null) {
                InputStream instream = entity.getContent();
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(instream, "UTF-8"));
                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    instream.close();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            client.getConnectionManager().shutdown(); // 关闭连接.
        }
        return result;
    }
    public static void main(String[] args) throws Exception {
        Map<String, Object> map = new HashMap<>();
        map.put("startCreatedDate", "2023-06-20 00:00:00");
        map.put("endCreatedDate", "2023-06-21 00:00:00");
        List<String> list = new ArrayList<>();
        list.add("receiptD");
        map.put("documentTypeCodeList", list);
        String json = JSON.toJSONString(map);
        System.out.println("--------------------" + json);
        String response = httpPostDocImport("http://apistage.huilianyi.com/gateway/e-archives/api/open/v1/documents/query?page=1&size=20", json, "6de63d6c-1acd-4b1c-89b8-e91c19442ab9", "Bearer");
        System.out.println(response);
    }
}
