package com.hand.hls.hlcm.acr.dto;

import com.hand.hap.mybatis.annotation.ExtensionAttribute;
import com.hand.hap.system.dto.BaseDTO;

import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * @Author Robert8900
 * @Date: 2018/8/29 13:40
 * @Description: 电子发票中间行表
 * @Purpose:
 **/
@ExtensionAttribute(disable = true)
@Table(name = "acr_ele_invoice_ln")
public class AcrEleInvoiceLn extends BaseDTO {
    @Id
    @GeneratedValue
    private Long eleInvoiceLnId;   //电子发票行ID/PK
    private Long eleInvoiceHdId;   //电子发票头ID
    private Long invoiceHdId;      //发票头ID
    private Long invoiceLnId;      //发票行ID
    private Long contractId;       //合同ID
    private Long cashflowId;       //现金流ID
    private String billNo;         //订单号
    private String name;            //商品名称
    private String code;            //商品编号（税收分类编码）
    private String lineType;       //发票行性质
    private String spec;            //规格型号
    private String unit;            //计量单位
    private Double taxRate;           //税率
    private Double quantity;          //数量
    private Double taxPrice;          //单价
    private Double totalAmount;       //含税金额
    private String yhzcbs;           //税收优惠政策 标志
    private String yhzcnr;          //享受税收优惠 政策内容
    private Long lslbs;             //零税率标识
    private String zxbm;               //自行编码
    private Double kce;                 //扣除额

    public Long getEleInvoiceLnId() {
        return eleInvoiceLnId;
    }

    public void setEleInvoiceLnId(Long eleInvoiceLnId) {
        this.eleInvoiceLnId = eleInvoiceLnId;
    }

    public Long getEleInvoiceHdId() {
        return eleInvoiceHdId;
    }

    public void setEleInvoiceHdId(Long eleInvoiceHdId) {
        this.eleInvoiceHdId = eleInvoiceHdId;
    }

    public Long getInvoiceHdId() {
        return invoiceHdId;
    }

    public void setInvoiceHdId(Long invoiceHdId) {
        this.invoiceHdId = invoiceHdId;
    }

    public Long getInvoiceLnId() {
        return invoiceLnId;
    }

    public void setInvoiceLnId(Long invoiceLnId) {
        this.invoiceLnId = invoiceLnId;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getCashflowId() {
        return cashflowId;
    }

    public void setCashflowId(Long cashflowId) {
        this.cashflowId = cashflowId;
    }

    public String getBillNo() {
        return billNo;
    }

    public void setBillNo(String billNo) {
        this.billNo = billNo;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getLineType() {
        return lineType;
    }

    public void setLineType(String lineType) {
        this.lineType = lineType;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public Double getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(Double taxRate) {
        this.taxRate = taxRate;
    }

    public Double getQuantity() {
        return quantity;
    }

    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public Double getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(Double taxPrice) {
        this.taxPrice = taxPrice;
    }

    public Double getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(Double totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getYhzcbs() {
        return yhzcbs;
    }

    public void setYhzcbs(String yhzcbs) {
        this.yhzcbs = yhzcbs;
    }

    public String getYhzcnr() {
        return yhzcnr;
    }

    public void setYhzcnr(String yhzcnr) {
        this.yhzcnr = yhzcnr;
    }

    public Long getLslbs() {
        return lslbs;
    }

    public void setLslbs(Long lslbs) {
        this.lslbs = lslbs;
    }

    public String getZxbm() {
        return zxbm;
    }

    public void setZxbm(String zxbm) {
        this.zxbm = zxbm;
    }

    public Double getKce() {
        return kce;
    }

    public void setKce(Double kce) {
        this.kce = kce;
    }
}

