package leaf.presentation.component.std;

import leaf.presentation.BuildSession;
import leaf.presentation.ViewContext;
import uncertain.ocm.IObjectRegistry;

import java.io.IOException;

public class HlsComponent extends Component {
    public static final String CONFIG_CONTEXT = "context";

    public HlsComponent(IObjectRegistry registry) {
        super(registry);
    }

    @Override
    public void onPreparePageContent(BuildSession session, ViewContext context) throws IOException {
        super.onPreparePageContent(session, context);
        addStyleSheet(session, context, "hlscomponent/hls-all.css");
        addStyleSheet(session, context, "hlscomponent/hls-component.css");
        addStyleSheet(session, context, "hlscomponent/hlsfont/hls-font.css");
//        addStyleSheet(session, context, "hlscomponent/block-con-status.css");
        addJavaScript(session, context, "hlscomponent/morris/raphael-2.0.2.min.js");
        addJavaScript(session, context, "hlscomponent/morris/morris.js");
//        addJavaScript(session, context, "ringchart/ringchart-render.js");
        addJavaScript(session, context, "hlscomponent/hls-component.js");
    }


    @Override
    public void onCreateViewContent(BuildSession session, ViewContext context) throws IOException {
        super.onCreateViewContent(session, context);
    }
}
