WHENEVER SQLERROR EXIT FAILURE ROLLBACK;
WHENEVER OSERROR  EXIT FAILURE ROLLBACK;

spool HLS_DOCUMENT_USE_SEAL.log

PROMPT
PROMPT CREATING TABLE HLS_DOCUMENT_USE_SEAL
PROMPT ============================
PROMPT
WHENEVER SQLERROR CONTINUE
 DROP TABLE HLS_DOCUMENT_USE_SEAL;
WHENEVER SQLERROR EXIT FAILURE ROLLBACK

-- Create table
create table HLS_DOCUMENT_USE_SEAL
(
  document_use_seal_id  number not null,
  document_table        varchar2(200),
  document_id           number,
  instruments_types     varchar2(200),
  common_seal           varchar2(1),
  corporate_visa_seal   varchar2(1),
  legal_seal            varchar2(1),
  con_special_seal      varchar2(1),
  financial_seal        varchar2(1),
  supervisio_seal       varchar2(1),
  seal_number           varchar2(200),

  --STADARD-WHO 不需修改
  object_version_number NUMBER default 1,
  request_id            NUMBER default -1,
  program_id            NUMBER default -1,
  created_by            NUMBER default -1 not null,
  creation_date         DATE default sysdate not null,
  last_updated_by       NUMBER default -1 not null,
  last_update_date      DATE default sysdate not null,
  last_update_login     NUMBER default -1
);
-- Add comments to the table
comment on table HLS_DOCUMENT_USE_SEAL
  is '用印信息';
-- Add comments to the columns
comment on column HLS_DOCUMENT_USE_SEAL.document_use_seal_id
  is 'PK';
  comment on column HLS_DOCUMENT_USE_SEAL.document_table
  is '关联单据表';
  comment on column HLS_DOCUMENT_USE_SEAL.document_id
  is '关联单据PK';
  comment on column HLS_DOCUMENT_USE_SEAL.instruments_types
  is '文书种类';
  comment on column HLS_DOCUMENT_USE_SEAL.common_seal
  is '公章';
  comment on column HLS_DOCUMENT_USE_SEAL.corporate_visa_seal
  is '法人签证章';
  comment on column HLS_DOCUMENT_USE_SEAL.legal_seal
  is '法人章';
  comment on column HLS_DOCUMENT_USE_SEAL.con_special_seal
  is '合同专用章';
  comment on column HLS_DOCUMENT_USE_SEAL.financial_seal
  is '财务章';
  comment on column HLS_DOCUMENT_USE_SEAL.supervisio_seal
  is '监管专用章';
  comment on column HLS_DOCUMENT_USE_SEAL.seal_number
  is '文书部数';
-- Create/Recreate primary, unique and foreign key constraints
alter table HLS_DOCUMENT_USE_SEAL
  add constraint HLS_DOCUMENT_USE_SEAL_PK primary key (document_use_seal_id);

create index HLS_DOCUMENT_USE_SEAL_N1 on HLS_DOCUMENT_USE_SEAL (document_table,document_id);

SPOOL OFF

EXIT
