package com.hand.hls.hlcm.jinsui.service.impl;

import com.hand.hls.hlcm.jinsui.service.IMakeInvService;
import com.hand.hls.hlcm.jinsui.mapper.MakeInvMapper;
import com.hand.hls.hlcm.jinsui.util.GetMakInvXmlUtil;
import com.hand.hls.hlcm.jinsui.util.ReadStringXmlUtil;
import jodd.util.PropertiesUtil;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.beans.factory.annotation.Autowired;


import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;

/**
 * Copyright (C) Hand Business Consulting Services
 * AllRights Reserved
 *
 * @Auther: ZhuXianfei
 * @Date: 2018/9/11 08:35
 * @Description: 金税纸质发票开票接口
 */


@Service
@Transactional(rollbackFor = Exception.class)
public class MakeInvServiceImpl implements IMakeInvService {

    @Autowired
    private MakeInvMapper makeInvMapper;

    /**
     * 开票执行请求
     *
     * @param jsonString 开票数据
     * @return strResult 反馈数据
     */
    @Override
    public String doMakeInv(String jsonString, Long invoiceHdId) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String strResult = null;

        Properties properties = new Properties();
        InputStream is = PropertiesUtil.class.getClassLoader().getResourceAsStream("config.properties");
        properties.load(is);
        //请求URL
        String rUrl = properties.getProperty("paper.webservice.url");
        System.out.println(rUrl);
        //封装请求xml报文
        String rXml = GetMakInvXmlUtil.getXml(jsonString);
        System.out.println("请求xml报文");
        System.out.println(rXml);
        System.out.println("请求xml报文");

        try {

            //获取发票号码
            String invoiceNumber = makeInvMapper.getInvNumber(invoiceHdId);
            String interfaceStatus = makeInvMapper.getInvInterfaceStatus(invoiceHdId);

            //没有发票号码 且 接口状态为未传输才调用
            if ("N".equals(invoiceNumber) && "UNTRANSFERED".equals(interfaceStatus)) {

                HttpClient client = new HttpClient();
                PostMethod doPost = new PostMethod(rUrl);
                client.getParams().setSoTimeout(60 * 1000);
                doPost.setRequestEntity(new StringRequestEntity(rXml, "text/xml", "utf-8"));

                //请求
                int statusCode = client.executeMethod(doPost);
                if (statusCode == HttpStatus.SC_OK) {
                    BufferedInputStream bis = new BufferedInputStream(doPost.getResponseBodyAsStream());
                    byte[] bytes = new byte[1024];
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    int count = 0;
                    while ((count = bis.read(bytes)) != -1) {
                        bos.write(bytes, 0, count);
                    }
                    byte[] strByte = bos.toByteArray();
                    //获取反馈报文
                    String responseString = new String(strByte, 0, strByte.length, "utf-8");
                    System.out.println(responseString);
                    //解析返回的数据
                    map = ReadStringXmlUtil.readStringXmlOut(responseString);

                    //将map数据转换成字符串
                    JSONObject jsonResult = JSONObject.fromObject(map);
                    strResult = jsonResult.toString();

                }


            }


        } catch (Exception e) {
            e.printStackTrace();
        }

        return strResult;

    }

}
